% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paginate_listing.R
\name{paginate_listing}
\alias{paginate_listing}
\title{Paginate listings}
\usage{
paginate_listing(
  lsting,
  page_type = "letter",
  font_family = "Courier",
  font_size = 8,
  lineheight = 1,
  landscape = FALSE,
  pg_width = NULL,
  pg_height = NULL,
  margins = c(top = 0.5, bottom = 0.5, left = 0.75, right = 0.75),
  lpp = NA_integer_,
  cpp = NA_integer_,
  colwidths = NULL,
  tf_wrap = !is.null(max_width),
  rep_cols = NULL,
  max_width = NULL,
  verbose = FALSE,
  print_pages = TRUE
)
}
\arguments{
\item{lsting}{(\code{listing_df} or \code{list})\cr the listing or list of listings to paginate.}

\item{page_type}{(\code{string})\cr name of a page type. See \code{\link[formatters]{page_types}}. Ignored
when \code{pg_width} and \code{pg_height} are set directly.}

\item{font_family}{(\code{string})\cr name of a font family. An error will be thrown
if the family named is not monospaced. Defaults to \code{"Courier"}.}

\item{font_size}{(\code{numeric(1)})\cr font size. Defaults to \code{12}.}

\item{lineheight}{(\code{numeric(1)})\cr line height. Defaults to \code{1}.}

\item{landscape}{(\code{flag})\cr whether the dimensions of \code{page_type} should be
inverted for landscape orientation. Defaults to \code{FALSE}, ignored when \code{pg_width} and
\code{pg_height} are set directly.}

\item{pg_width}{(\code{numeric(1)})\cr page width in inches.}

\item{pg_height}{(\code{numeric(1)})\cr page height in inches.}

\item{margins}{(\code{numeric(4)})\cr named numeric vector containing \code{"bottom"}, \code{"left"},
\code{"top"}, and \code{"right"} margins in inches. Defaults to \code{.5} inches for both vertical
margins and \code{.75} for both horizontal margins.}

\item{lpp}{(\code{numeric(1)} or \code{NULL})\cr number of rows/lines (excluding titles and footers)
to include per page. Standard is \code{70} while \code{NULL} disables vertical pagination.}

\item{cpp}{(\code{numeric(1)} or \code{NULL})\cr width (in characters) of the pages for horizontal
pagination. \code{NULL} (the default) indicates no horizontal pagination should be done.}

\item{colwidths}{(\code{numeric})\cr vector of column widths (in characters) for use in vertical pagination.}

\item{tf_wrap}{(\code{flag})\cr whether the text for title, subtitles, and footnotes should be wrapped.}

\item{rep_cols}{(\code{numeric(1)})\cr number of \emph{columns} (not including row labels) to be repeated on every page.
Defaults to 0.}

\item{max_width}{(\code{integer(1)}, \code{string} or \code{NULL})\cr width that title and footer (including
footnotes) materials should be word-wrapped to. If \code{NULL}, it is set to the current print width of the
session (\code{getOption("width")}). If set to \code{"auto"}, the width of the table (plus any table inset) is
used. Parameter is ignored if \code{tf_wrap = FALSE}.}

\item{verbose}{(\code{flag})\cr whether additional informative messages about the search for
pagination breaks should be shown. Defaults to \code{FALSE}.}

\item{print_pages}{(\code{flag})\cr whether the paginated listing should be printed to the console
(\code{cat(toString(x))}).}
}
\value{
A list of \code{listing_df} objects where each list element corresponds to a separate page.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Pagination of a listing. This can be vertical for long listings with many
rows and/or horizontal if there are many columns. This function is a wrapper of
\code{\link[formatters:paginate_indices]{formatters::paginate_to_mpfs()}} and it is mainly meant for exploration and testing.
}
\examples{
dat <- ex_adae
lsting <- as_listing(dat[1:25, ], disp_cols = c("USUBJID", "AESOC", "RACE", "AETOXGR", "BMRKR1"))
mat <- matrix_form(lsting)
cat(toString(mat))

paginate_listing(lsting, lpp = 10)

paginate_listing(lsting, cpp = 100, lpp = 40)

paginate_listing(lsting, cpp = 80, lpp = 40, verbose = TRUE)

}
