% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/def_intervals.R
\name{def_intervals}
\alias{def_intervals}
\title{Define Macrostrat time intervals}
\usage{
def_intervals(
  timescale = NULL,
  interval_name = NULL,
  interval_id = NULL,
  age = NULL,
  age_top = NULL,
  age_bottom = NULL,
  rule = NULL,
  true_colors = NULL
)
}
\arguments{
\item{timescale}{\code{character}. The name of the desired timescale to
return a definition for (e.g., "international epochs").}

\item{interval_name}{\code{character}. The name of the desired interval to
return a definition for.}

\item{interval_id}{\code{integer}. The identification number(s) of the
desired time interval to return a definition for.}

\item{age}{\code{numeric}. Age in millions of years before present to
return an interval definition for. All intervals overlapping with this
age will be returned.}

\item{age_top}{\code{numeric}. The minimum age for which interval
definitions should be returned, in millions of years before present. If
specified, \code{age_bottom} must also be specified, and this must be younger
than \code{age_bottom}.}

\item{age_bottom}{\code{numeric}. The maximum age for which interval
definitions should be returned, in millions of years before present. If
specified, \code{age_top} must also be specified, and this must be older than
\code{age_top}.}

\item{rule}{\code{character}. How should interval definitions be returned
for the given \code{age_top} and \code{age_bottom}? Use "contains" to return all
intervals that fall entirely within \code{age_top} and \code{age_bottom}. Use
"exact" to return any intervals with both boundaries equal to \code{age_top}
and \code{age_bottom}. Use "loose" (the default) to return all intervals
touching the range of \code{age_top} and \code{age_bottom}. If \code{age_top} and
\code{age_bottom} are not provided, this argument is ignored.}

\item{true_colors}{\code{logical}. Should the original international time
scale colors be returned? Defaults to \code{TRUE}.}
}
\value{
A \code{data.frame} containing the following columns:
\itemize{
\item \code{int_id}: The unique identification number of the time
interval.
\item \code{name}: The name of the time interval.
\item \code{abbrev}: The standard abbreviation for the time interval
name, if one exists.
\item \code{t_age}: The top age (minimum age) in millions of years
before present.
\item \code{b_age}: The bottom age (maximum age) in millions of years
before present.
\item \code{int_type}: The temporal rank of the interval (e.g., "age",
"epoch", "chron").
\item \code{timescales}: A \code{data.frame} containing the timescale(s)
that the interval is included in (see \code{\link[=def_timescales]{def_timescales()}} for more
details), with the following columns:
\itemize{
\item \code{timescale_id}: The unique identification number of the
timescale.
\item \code{name}: The name of the timescale.
}
\item \code{color}: The recommended coloring for units based on dominant
lithology.
}
}
\description{
A function to retrieve Macrostrat time interval definitions
matching a user-specific search criteria. If no arguments are specified
(the default), all time interval definitions are returned.
}
\section{Developer(s)}{

Lewis A. Jones
}

\section{Reviewer(s)}{

William Gearty
}

\examples{
\donttest{
# Return all intervals
ex1 <- def_intervals()
# Return all specific timescale intervals
ex2 <- def_intervals(timescale = "international ages")
# Return for specific age
ex3 <- def_intervals(timescale = "international ages", age = 70)
}
}
\seealso{
Timescales and time intervals:
\code{\link{def_timescales}()}
}
\concept{defs_time}
