% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_islands.R
\name{ms_filter_islands}
\alias{ms_filter_islands}
\title{Remove small detached polygons (islands)}
\usage{
ms_filter_islands(input, min_area = NULL, min_vertices = NULL,
  drop_null_geometries = TRUE, force_FC = TRUE, sys = FALSE)
}
\arguments{
\item{input}{spatial object to filter. One of:
\itemize{
\item \code{geo_json} or \code{character} polygons;
\item \code{geo_list} polygons;
\item \code{SpatialPolygons*};
\item \code{sf} or \code{sfc} polygons object
}}

\item{min_area}{minimum area of polygons to retain. Area is calculated using
planar geometry, except for the area of unprojected polygons, which is
calculated using spherical geometry in units of square meters.}

\item{min_vertices}{minimum number of vertices in polygons to retain.}

\item{drop_null_geometries}{should features with empty geometries be dropped?
Default \code{TRUE}. Ignored for \code{SpatialPolyons*}, as it is always
\code{TRUE}.}

\item{force_FC}{should the output be forced to be a \code{FeatureCollection}
even if there are no attributes? Default \code{TRUE}.
\code{FeatureCollections} are more compatible with \code{rgdal::readOGR}
and \code{geojsonio::geojson_sp}. If \code{FALSE} and there are no
attributes associated with the geometries, a \code{GeometryCollection} will
be output. Ignored for \code{Spatial} objects, as the output is always the
same class as the input.}

\item{sys}{Should the system mapshaper be used instead of the bundled mapshaper? Gives
better performance on large files. Requires the mapshapr node package to be installed
and on the PATH.}
}
\value{
object with only specified features retained, in the same class as
the input
}
\description{
Remove small detached polygons, keeping those with a minimum area and/or a
minimum number of vertices. Optionally remove null geometries.
}
\examples{
library(geojsonio)
library(sp)

poly <- structure("{\\"type\\":\\"FeatureCollection\\",
           \\"features\\":[{\\"type\\":\\"Feature\\",\\"properties\\":{},
           \\"geometry\\":{\\"type\\":\\"Polygon\\",
           \\"coordinates\\":[[[102,2],[102,4],[104,4],[104,2],[102,2]]]}},
           {\\"type\\":\\"Feature\\",\\"properties\\":{},
           \\"geometry\\":{\\"type\\":\\"Polygon\\",
           \\"coordinates\\":[[[100,2],[98,4],[101.5,4],[100,2]]]}},
           {\\"type\\":\\"Feature\\",\\"properties\\":{},
           \\"geometry\\":{\\"type\\":\\"Polygon\\",
           \\"coordinates\\":[[[100,0],[100,1],[101,1],[101,0],[100,0]]]}}]}",
           class = c("json", "geo_json"))

poly <- geojson_sp(poly)
plot(poly)

out <- ms_filter_islands(poly, min_area = 12391399903)
plot(out)

}
