% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmargint-fn.R
\name{kernel10}
\alias{kernel10}
\title{Order 10 kernel}
\usage{
kernel10(x)
}
\arguments{
\item{x}{A vector of real numbers.}
}
\value{
A vector of the same length as \code{x} where each entry is \code{0.75 * ( 1 - x^2 ) * ( 315/128 - 105/32 * x^2 + 63/64 * x^4 - 3/32 * x^6 - 1/384 * x^8 )} and 0 otherwise.
}
\description{
This function evaluates a kernel of order 10. A kernel of order 10.
}
\details{
This function evaluates a kernel of order 10. A kernel L is a kernel of order 10 if it integrates 1, the integrals of u^j L(u) are 0 for 1 <= j < 10 (j integer) and the integral of u^10 L(u) is different from 0.
}
\examples{
x <- seq(-2,2,length=10)
kernel10(x)

}
\author{
Alejandra Martinez, \email{ale_m_martinez@hotmail.com}, Matias Salibian-Barrera
}
