% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/html_notebook.R
\name{html_notebook}
\alias{html_notebook}
\title{Convert to an HTML notebook}
\usage{
html_notebook(
  toc = FALSE,
  toc_depth = 3,
  toc_float = FALSE,
  number_sections = FALSE,
  fig_width = 7,
  fig_height = 5,
  fig_retina = 2,
  fig_caption = TRUE,
  code_folding = "show",
  theme = "default",
  highlight = "textmate",
  mathjax = "default",
  extra_dependencies = NULL,
  css = NULL,
  includes = NULL,
  md_extensions = NULL,
  pandoc_args = NULL,
  output_source = NULL,
  self_contained = TRUE,
  ...
)
}
\arguments{
\item{toc}{\code{TRUE} to include a table of contents in the output}

\item{toc_depth}{Depth of headers to include in table of contents}

\item{toc_float}{\code{TRUE} to float the table of contents to the left of the
main document content. Rather than \code{TRUE} you may also pass a list of
options that control the behavior of the floating table of contents. See the
\emph{Floating Table of Contents} section below for details.}

\item{number_sections}{\code{TRUE} to number section headings}

\item{fig_width}{Default width (in inches) for figures}

\item{fig_height}{Default height (in inches) for figures}

\item{fig_retina}{Scaling to perform for retina displays (defaults to 2, which
currently works for all widely used retina displays). Set to \code{NULL} to
prevent retina scaling. Note that this will always be \code{NULL} when
\code{keep_md} is specified (this is because \code{fig_retina} relies on
outputting HTML directly into the markdown document).}

\item{fig_caption}{\code{TRUE} to render figures with captions}

\item{code_folding}{Enable document readers to toggle the display of R code
chunks. Specify \code{"none"} to display all code chunks (assuming
they were knit with \code{echo = TRUE}). Specify \code{"hide"} to hide all R
code chunks by default (users can show hidden code chunks either
individually or document-wide). Specify \code{"show"} to show all R code
chunks by default.}

\item{theme}{One of the following:
\itemize{
\item A \code{\link[bslib:bs_theme]{bslib::bs_theme()}} object (or a list of \code{\link[bslib:bs_theme]{bslib::bs_theme()}} argument values)
\itemize{
\item Use this option for custom themes using Bootstrap 4 or 3.
\item In this case, any \code{.scss}/\code{.sass} files provided to the \code{css}
parameter may utilize the \code{theme}'s underlying Sass utilities
(e.g., variables, mixins, etc).
}
\item \code{NULL} for no theme (i.e., no \code{\link[=html_dependency_bootstrap]{html_dependency_bootstrap()}}).
\item A character string specifying a \href{https://bootswatch.com/3/}{Bootswatch 3}
theme name (for backwards-compatibility).
}}

\item{highlight}{Syntax highlighting style. Supported styles include
"default", "tango", "pygments", "kate", "monochrome", "espresso", "zenburn",
"haddock", and "textmate". Pass \code{NULL} to prevent syntax highlighting.}

\item{mathjax}{Include mathjax. The "default" option uses an https URL from a
MathJax CDN. The "local" option uses a local version of MathJax (which is
copied into the output directory). You can pass an alternate URL or pass
\code{NULL} to exclude MathJax entirely.}

\item{extra_dependencies}{Additional function arguments to pass to the
base R Markdown HTML output formatter \code{\link{html_document_base}}}

\item{css}{One or more css files to include}

\item{includes}{Named list of additional content to include within the
document (typically created using the \code{\link{includes}} function).}

\item{md_extensions}{Markdown extensions to be added or removed from the
default definition or R Markdown. See the \code{\link{rmarkdown_format}} for
additional details.}

\item{pandoc_args}{Additional command line options to pass to pandoc}

\item{output_source}{Define an output source for \R chunks (ie,
outputs to use instead of those produced by evaluating the
underlying \R code). See \code{\link{html_notebook_output}} for
more details.}

\item{self_contained}{Produce a standalone HTML file with no external
dependencies. Defaults to \code{TRUE}. In notebooks, setting this to
\code{FALSE} is not recommended, since the setting does not apply to
embedded notebook output such as plots and HTML widgets.}

\item{...}{Additional function arguments to pass to the
base R Markdown HTML output formatter \code{\link{html_document_base}}}
}
\description{
Format for converting from R Markdown to an HTML notebook.
}
\details{
See the \href{https://rmarkdown.rstudio.com/r_notebook_format.html}{online
documentation} for additional details on using the \code{html_notebook}
format.
}
