/*
 * Decompiled with CFR 0.152.
 */
package dmLab.classifier;

import dmLab.array.FArray;
import dmLab.array.functions.DiscFunctions;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Properties;

public abstract class Params {
    protected String fileType = "cfg";
    public boolean verbose = false;
    public boolean debug = false;

    public Params() {
        this.setDefault();
    }

    public abstract boolean setDefault();

    public abstract boolean check(FArray var1);

    protected abstract boolean update(Properties var1);

    /*
     * WARNING - void declaration
     */
    protected final void set(Params p) {
        void var1_1;
        this.fileType = p.fileType;
        this.verbose = p.verbose;
        this.debug = var1_1.debug;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean load(String path, String inputFileName) {
        void var3_4;
        Properties properties = new Properties();
        if (path == null || inputFileName == null) {
            return this.setDefault();
        }
        String myPath = "";
        String ext = DiscFunctions.getFileExtension(inputFileName);
        if (path.length() != 0) {
            myPath = String.valueOf(path) + "//";
        }
        String filePath = ext.equalsIgnoreCase(this.fileType) ? String.valueOf(myPath) + inputFileName : String.valueOf(myPath) + inputFileName + "." + this.fileType;
        try {
            FileInputStream cfgFile = new FileInputStream(filePath);
            properties.load(cfgFile);
            cfgFile.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (this.verbose) {
                System.out.println("Config file: '" + filePath + "' not found. Default params will be used.");
            }
            return this.setDefault();
        }
        catch (IOException e) {
            void var2_3;
            void var1_1;
            System.err.println("Error: Loading config file. File" + (String)var1_1);
            var2_3.printStackTrace();
            return false;
        }
        this.verbose = Boolean.valueOf(properties.getProperty("verbose", "false"));
        this.debug = Boolean.valueOf(properties.getProperty("debug", "false"));
        return this.update((Properties)var3_4);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean save(String path, String filename) {
        String cfgFilePath = String.valueOf(path) + "//" + filename + "." + this.fileType;
        if (path.length() == 0) {
            void var2_4;
            cfgFilePath = String.valueOf(var2_4) + this.fileType;
        }
        File cfgFile = new File(cfgFilePath);
        try {
            FileWriter writer = new FileWriter(cfgFile);
        }
        catch (IOException e) {
            System.err.println("Error: Cannot create the file. File: " + cfgFilePath);
            e.printStackTrace();
            return false;
        }
        try {
            e.write(this.toString());
            e.close();
        }
        catch (IOException e) {
            void var1_3;
            void var3_5;
            System.err.println("Error: Saving and Closing config file. File: " + (String)var3_5);
            var1_3.printStackTrace();
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var1_1;
        StringBuffer tmp = new StringBuffer();
        tmp.append("verbose=" + this.verbose).append('\n');
        tmp.append("debug=" + this.debug).append('\n');
        return var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static String booleanParamToString(boolean paramValue, String paramName) {
        void var2_2;
        boolean bl;
        StringBuffer tmp = new StringBuffer();
        if (bl) {
            tmp.append(paramName).append(" is ON");
        } else {
            void var1_1;
            tmp.append((String)var1_1).append(" is OFF");
        }
        return var2_2.toString();
    }
}

