/*
 * Decompiled with CFR 0.152.
 */
package cern.colt;

import cern.colt.function.ByteComparator;
import cern.colt.function.CharComparator;
import cern.colt.function.DoubleComparator;
import cern.colt.function.FloatComparator;
import cern.colt.function.IntComparator;
import cern.colt.function.LongComparator;
import cern.colt.function.ShortComparator;
import cern.colt.list.DoubleArrayList;
import cern.colt.list.FloatArrayList;
import java.util.Comparator;

public class Sorting {
    private static final int SMALL = 7;
    private static final int MEDIUM = 40;

    protected Sorting() {
    }

    public static int binarySearchFromTo(byte[] byArray, byte by, int n, int n2) {
        while (n <= n2) {
            int n3 = (n + n2) / 2;
            byte by2 = byArray[n3];
            if (by2 < by) {
                n = n3 + 1;
                continue;
            }
            if (by2 > by) {
                n2 = n3 - 1;
                continue;
            }
            return n3;
        }
        return -(n + 1);
    }

    public static int binarySearchFromTo(char[] cArray, char c, int n, int n2) {
        while (n <= n2) {
            int n3 = (n + n2) / 2;
            char c2 = cArray[n3];
            if (c2 < c) {
                n = n3 + 1;
                continue;
            }
            if (c2 > c) {
                n2 = n3 - 1;
                continue;
            }
            return n3;
        }
        return -(n + 1);
    }

    public static int binarySearchFromTo(double[] dArray, double d, int n, int n2) {
        while (n <= n2) {
            int n3 = (n + n2) / 2;
            double d2 = dArray[n3];
            if (d2 < d) {
                n = n3 + 1;
                continue;
            }
            if (d2 > d) {
                n2 = n3 - 1;
                continue;
            }
            return n3;
        }
        return -(n + 1);
    }

    public static int binarySearchFromTo(float[] fArray, float f, int n, int n2) {
        while (n <= n2) {
            int n3 = (n + n2) / 2;
            float f2 = fArray[n3];
            if (f2 < f) {
                n = n3 + 1;
                continue;
            }
            if (f2 > f) {
                n2 = n3 - 1;
                continue;
            }
            return n3;
        }
        return -(n + 1);
    }

    public static int binarySearchFromTo(int[] nArray, int n, int n2, int n3) {
        while (n2 <= n3) {
            int n4 = (n2 + n3) / 2;
            int n5 = nArray[n4];
            if (n5 < n) {
                n2 = n4 + 1;
                continue;
            }
            if (n5 > n) {
                n3 = n4 - 1;
                continue;
            }
            return n4;
        }
        return -(n2 + 1);
    }

    public static int binarySearchFromTo(long[] lArray, long l, int n, int n2) {
        while (n <= n2) {
            int n3 = (n + n2) / 2;
            long l2 = lArray[n3];
            if (l2 < l) {
                n = n3 + 1;
                continue;
            }
            if (l2 > l) {
                n2 = n3 - 1;
                continue;
            }
            return n3;
        }
        return -(n + 1);
    }

    public static int binarySearchFromTo(Object[] objectArray, Object object, int n, int n2, Comparator comparator) {
        while (n <= n2) {
            int n3 = (n + n2) / 2;
            Object object2 = objectArray[n3];
            int n4 = comparator.compare(object2, object);
            if (n4 < 0) {
                n = n3 + 1;
                continue;
            }
            if (n4 > 0) {
                n2 = n3 - 1;
                continue;
            }
            return n3;
        }
        return -(n + 1);
    }

    public static int binarySearchFromTo(short[] sArray, short s, int n, int n2) {
        while (n <= n2) {
            int n3 = (n + n2) / 2;
            short s2 = sArray[n3];
            if (s2 < s) {
                n = n3 + 1;
                continue;
            }
            if (s2 > s) {
                n2 = n3 - 1;
                continue;
            }
            return n3;
        }
        return -(n + 1);
    }

    public static int binarySearchFromTo(int n, int n2, IntComparator intComparator) {
        while (n <= n2) {
            int n3 = (n + n2) / 2;
            int n4 = intComparator.compare(0, n3);
            if (n4 < 0) {
                n = n3 + 1;
                continue;
            }
            if (n4 > 0) {
                n2 = n3 - 1;
                continue;
            }
            return n3;
        }
        return -(n + 1);
    }

    private static int lower_bound(int[] nArray, int n, int n2, int n3) {
        int n4 = n2 - n;
        while (n4 > 0) {
            int n5 = n4 / 2;
            int n6 = n + n5;
            if (nArray[n6] < n3) {
                n = n6 + 1;
                n4 -= n5 + 1;
                continue;
            }
            n4 = n5;
        }
        return n;
    }

    private static int upper_bound(int[] nArray, int n, int n2, int n3) {
        int n4 = n2 - n;
        while (n4 > 0) {
            int n5 = n4 / 2;
            int n6 = n + n5;
            if (n3 < nArray[n6]) {
                n4 = n5;
                continue;
            }
            n = n6 + 1;
            n4 -= n5 + 1;
        }
        return n;
    }

    private static void inplace_merge(int[] nArray, int n, int n2, int n3) {
        int n4;
        int n5;
        if (n >= n2 || n2 >= n3) {
            return;
        }
        if (n3 - n == 2) {
            if (nArray[n2] < nArray[n]) {
                int n6 = nArray[n];
                nArray[n] = nArray[n2];
                nArray[n2] = n6;
            }
            return;
        }
        if (n2 - n > n3 - n2) {
            n5 = n + (n2 - n) / 2;
            n4 = Sorting.lower_bound(nArray, n2, n3, nArray[n5]);
        } else {
            n4 = n2 + (n3 - n2) / 2;
            n5 = Sorting.upper_bound(nArray, n, n2, nArray[n4]);
        }
        int n7 = n5;
        int n8 = n2;
        int n9 = n4;
        if (n8 != n7 && n8 != n9) {
            int n10;
            int n11 = n7;
            int n12 = n8;
            while (n11 < --n12) {
                n10 = nArray[n11];
                nArray[n12] = nArray[n11];
                nArray[n11++] = n10;
            }
            n11 = n8;
            n12 = n9;
            while (n11 < --n12) {
                n10 = nArray[n11];
                nArray[n12] = nArray[n11];
                nArray[n11++] = n10;
            }
            n11 = n7;
            n12 = n9;
            while (n11 < --n12) {
                n10 = nArray[n11];
                nArray[n12] = nArray[n11];
                nArray[n11++] = n10;
            }
        }
        n2 = n5 + (n4 - n2);
        Sorting.inplace_merge(nArray, n, n5, n2);
        Sorting.inplace_merge(nArray, n2, n4, n3);
    }

    private static int med3(byte[] byArray, int n, int n2, int n3, ByteComparator byteComparator) {
        int n4 = byteComparator.compare(byArray[n], byArray[n2]);
        int n5 = byteComparator.compare(byArray[n], byArray[n3]);
        int n6 = byteComparator.compare(byArray[n2], byArray[n3]);
        return n4 < 0 ? (n6 < 0 ? n2 : (n5 < 0 ? n3 : n)) : (n6 > 0 ? n2 : (n5 > 0 ? n3 : n));
    }

    private static int med3(char[] cArray, int n, int n2, int n3, CharComparator charComparator) {
        int n4 = charComparator.compare(cArray[n], cArray[n2]);
        int n5 = charComparator.compare(cArray[n], cArray[n3]);
        int n6 = charComparator.compare(cArray[n2], cArray[n3]);
        return n4 < 0 ? (n6 < 0 ? n2 : (n5 < 0 ? n3 : n)) : (n6 > 0 ? n2 : (n5 > 0 ? n3 : n));
    }

    private static int med3(double[] dArray, int n, int n2, int n3, DoubleComparator doubleComparator) {
        int n4 = doubleComparator.compare(dArray[n], dArray[n2]);
        int n5 = doubleComparator.compare(dArray[n], dArray[n3]);
        int n6 = doubleComparator.compare(dArray[n2], dArray[n3]);
        return n4 < 0 ? (n6 < 0 ? n2 : (n5 < 0 ? n3 : n)) : (n6 > 0 ? n2 : (n5 > 0 ? n3 : n));
    }

    private static int med3(float[] fArray, int n, int n2, int n3, FloatComparator floatComparator) {
        int n4 = floatComparator.compare(fArray[n], fArray[n2]);
        int n5 = floatComparator.compare(fArray[n], fArray[n3]);
        int n6 = floatComparator.compare(fArray[n2], fArray[n3]);
        return n4 < 0 ? (n6 < 0 ? n2 : (n5 < 0 ? n3 : n)) : (n6 > 0 ? n2 : (n5 > 0 ? n3 : n));
    }

    private static int med3(int[] nArray, int n, int n2, int n3, IntComparator intComparator) {
        int n4 = intComparator.compare(nArray[n], nArray[n2]);
        int n5 = intComparator.compare(nArray[n], nArray[n3]);
        int n6 = intComparator.compare(nArray[n2], nArray[n3]);
        return n4 < 0 ? (n6 < 0 ? n2 : (n5 < 0 ? n3 : n)) : (n6 > 0 ? n2 : (n5 > 0 ? n3 : n));
    }

    private static int med3(long[] lArray, int n, int n2, int n3, LongComparator longComparator) {
        int n4 = longComparator.compare(lArray[n], lArray[n2]);
        int n5 = longComparator.compare(lArray[n], lArray[n3]);
        int n6 = longComparator.compare(lArray[n2], lArray[n3]);
        return n4 < 0 ? (n6 < 0 ? n2 : (n5 < 0 ? n3 : n)) : (n6 > 0 ? n2 : (n5 > 0 ? n3 : n));
    }

    private static int med3(Object[] objectArray, int n, int n2, int n3) {
        int n4 = ((Comparable)objectArray[n]).compareTo((Comparable)objectArray[n2]);
        int n5 = ((Comparable)objectArray[n]).compareTo((Comparable)objectArray[n3]);
        int n6 = ((Comparable)objectArray[n2]).compareTo((Comparable)objectArray[n3]);
        return n4 < 0 ? (n6 < 0 ? n2 : (n5 < 0 ? n3 : n)) : (n6 > 0 ? n2 : (n5 > 0 ? n3 : n));
    }

    private static int med3(Object[] objectArray, int n, int n2, int n3, Comparator comparator) {
        int n4 = comparator.compare(objectArray[n], objectArray[n2]);
        int n5 = comparator.compare(objectArray[n], objectArray[n3]);
        int n6 = comparator.compare(objectArray[n2], objectArray[n3]);
        return n4 < 0 ? (n6 < 0 ? n2 : (n5 < 0 ? n3 : n)) : (n6 > 0 ? n2 : (n5 > 0 ? n3 : n));
    }

    private static int med3(short[] sArray, int n, int n2, int n3, ShortComparator shortComparator) {
        int n4 = shortComparator.compare(sArray[n], sArray[n2]);
        int n5 = shortComparator.compare(sArray[n], sArray[n3]);
        int n6 = shortComparator.compare(sArray[n2], sArray[n3]);
        return n4 < 0 ? (n6 < 0 ? n2 : (n5 < 0 ? n3 : n)) : (n6 > 0 ? n2 : (n5 > 0 ? n3 : n));
    }

    public static void mergeSort(byte[] byArray, int n, int n2) {
        Sorting.rangeCheck(byArray.length, n, n2);
        byte[] byArray2 = (byte[])byArray.clone();
        Sorting.mergeSort1(byArray2, byArray, n, n2);
    }

    public static void mergeSort(byte[] byArray, int n, int n2, ByteComparator byteComparator) {
        Sorting.rangeCheck(byArray.length, n, n2);
        byte[] byArray2 = (byte[])byArray.clone();
        Sorting.mergeSort1(byArray2, byArray, n, n2, byteComparator);
    }

    public static void mergeSort(char[] cArray, int n, int n2) {
        Sorting.rangeCheck(cArray.length, n, n2);
        char[] cArray2 = (char[])cArray.clone();
        Sorting.mergeSort1(cArray2, cArray, n, n2);
    }

    public static void mergeSort(char[] cArray, int n, int n2, CharComparator charComparator) {
        Sorting.rangeCheck(cArray.length, n, n2);
        char[] cArray2 = (char[])cArray.clone();
        Sorting.mergeSort1(cArray2, cArray, n, n2, charComparator);
    }

    public static void mergeSort(double[] dArray, int n, int n2) {
        Sorting.mergeSort2(dArray, n, n2);
    }

    public static void mergeSort(double[] dArray, int n, int n2, DoubleComparator doubleComparator) {
        Sorting.rangeCheck(dArray.length, n, n2);
        double[] dArray2 = (double[])dArray.clone();
        Sorting.mergeSort1(dArray2, dArray, n, n2, doubleComparator);
    }

    public static void mergeSort(float[] fArray, int n, int n2) {
        Sorting.mergeSort2(fArray, n, n2);
    }

    public static void mergeSort(float[] fArray, int n, int n2, FloatComparator floatComparator) {
        Sorting.rangeCheck(fArray.length, n, n2);
        float[] fArray2 = (float[])fArray.clone();
        Sorting.mergeSort1(fArray2, fArray, n, n2, floatComparator);
    }

    public static void mergeSort(int[] nArray, int n, int n2) {
        Sorting.rangeCheck(nArray.length, n, n2);
        int[] nArray2 = (int[])nArray.clone();
        Sorting.mergeSort1(nArray2, nArray, n, n2);
    }

    public static void mergeSort(int[] nArray, int n, int n2, IntComparator intComparator) {
        Sorting.rangeCheck(nArray.length, n, n2);
        int[] nArray2 = (int[])nArray.clone();
        Sorting.mergeSort1(nArray2, nArray, n, n2, intComparator);
    }

    public static void mergeSort(long[] lArray, int n, int n2) {
        Sorting.rangeCheck(lArray.length, n, n2);
        long[] lArray2 = (long[])lArray.clone();
        Sorting.mergeSort1(lArray2, lArray, n, n2);
    }

    public static void mergeSort(long[] lArray, int n, int n2, LongComparator longComparator) {
        Sorting.rangeCheck(lArray.length, n, n2);
        long[] lArray2 = (long[])lArray.clone();
        Sorting.mergeSort1(lArray2, lArray, n, n2, longComparator);
    }

    public static void mergeSort(short[] sArray, int n, int n2) {
        Sorting.rangeCheck(sArray.length, n, n2);
        short[] sArray2 = (short[])sArray.clone();
        Sorting.mergeSort1(sArray2, sArray, n, n2);
    }

    public static void mergeSort(short[] sArray, int n, int n2, ShortComparator shortComparator) {
        Sorting.rangeCheck(sArray.length, n, n2);
        short[] sArray2 = (short[])sArray.clone();
        Sorting.mergeSort1(sArray2, sArray, n, n2, shortComparator);
    }

    private static void mergeSort1(byte[] byArray, byte[] byArray2, int n, int n2) {
        int n3 = n2 - n;
        if (n3 < 7) {
            for (int i = n; i < n2; ++i) {
                for (int j = i; j > n && byArray2[j - 1] > byArray2[j]; --j) {
                    Sorting.swap(byArray2, j, j - 1);
                }
            }
            return;
        }
        int n4 = (n + n2) / 2;
        Sorting.mergeSort1(byArray2, byArray, n, n4);
        Sorting.mergeSort1(byArray2, byArray, n4, n2);
        if (byArray[n4 - 1] <= byArray[n4]) {
            System.arraycopy(byArray, n, byArray2, n, n3);
            return;
        }
        int n5 = n;
        int n6 = n4;
        for (int i = n; i < n2; ++i) {
            byArray2[i] = n6 >= n2 || n5 < n4 && byArray[n5] <= byArray[n6] ? byArray[n5++] : byArray[n6++];
        }
    }

    private static void mergeSort1(byte[] byArray, byte[] byArray2, int n, int n2, ByteComparator byteComparator) {
        int n3 = n2 - n;
        if (n3 < 7) {
            for (int i = n; i < n2; ++i) {
                for (int j = i; j > n && byteComparator.compare(byArray2[j - 1], byArray2[j]) > 0; --j) {
                    Sorting.swap(byArray2, j, j - 1);
                }
            }
            return;
        }
        int n4 = (n + n2) / 2;
        Sorting.mergeSort1(byArray2, byArray, n, n4, byteComparator);
        Sorting.mergeSort1(byArray2, byArray, n4, n2, byteComparator);
        if (byteComparator.compare(byArray[n4 - 1], byArray[n4]) <= 0) {
            System.arraycopy(byArray, n, byArray2, n, n3);
            return;
        }
        int n5 = n;
        int n6 = n4;
        for (int i = n; i < n2; ++i) {
            byArray2[i] = n6 >= n2 || n5 < n4 && byteComparator.compare(byArray[n5], byArray[n6]) <= 0 ? byArray[n5++] : byArray[n6++];
        }
    }

    private static void mergeSort1(char[] cArray, char[] cArray2, int n, int n2) {
        int n3 = n2 - n;
        if (n3 < 7) {
            for (int i = n; i < n2; ++i) {
                for (int j = i; j > n && cArray2[j - 1] > cArray2[j]; --j) {
                    Sorting.swap(cArray2, j, j - 1);
                }
            }
            return;
        }
        int n4 = (n + n2) / 2;
        Sorting.mergeSort1(cArray2, cArray, n, n4);
        Sorting.mergeSort1(cArray2, cArray, n4, n2);
        if (cArray[n4 - 1] <= cArray[n4]) {
            System.arraycopy(cArray, n, cArray2, n, n3);
            return;
        }
        int n5 = n;
        int n6 = n4;
        for (int i = n; i < n2; ++i) {
            cArray2[i] = n6 >= n2 || n5 < n4 && cArray[n5] <= cArray[n6] ? cArray[n5++] : cArray[n6++];
        }
    }

    private static void mergeSort1(char[] cArray, char[] cArray2, int n, int n2, CharComparator charComparator) {
        int n3 = n2 - n;
        if (n3 < 7) {
            for (int i = n; i < n2; ++i) {
                for (int j = i; j > n && charComparator.compare(cArray2[j - 1], cArray2[j]) > 0; --j) {
                    Sorting.swap(cArray2, j, j - 1);
                }
            }
            return;
        }
        int n4 = (n + n2) / 2;
        Sorting.mergeSort1(cArray2, cArray, n, n4, charComparator);
        Sorting.mergeSort1(cArray2, cArray, n4, n2, charComparator);
        if (charComparator.compare(cArray[n4 - 1], cArray[n4]) <= 0) {
            System.arraycopy(cArray, n, cArray2, n, n3);
            return;
        }
        int n5 = n;
        int n6 = n4;
        for (int i = n; i < n2; ++i) {
            cArray2[i] = n6 >= n2 || n5 < n4 && charComparator.compare(cArray[n5], cArray[n6]) <= 0 ? cArray[n5++] : cArray[n6++];
        }
    }

    private static void mergeSort1(double[] dArray, double[] dArray2, int n, int n2) {
        int n3 = n2 - n;
        if (n3 < 7) {
            for (int i = n; i < n2; ++i) {
                for (int j = i; j > n && dArray2[j - 1] > dArray2[j]; --j) {
                    Sorting.swap(dArray2, j, j - 1);
                }
            }
            return;
        }
        int n4 = (n + n2) / 2;
        Sorting.mergeSort1(dArray2, dArray, n, n4);
        Sorting.mergeSort1(dArray2, dArray, n4, n2);
        if (dArray[n4 - 1] <= dArray[n4]) {
            System.arraycopy(dArray, n, dArray2, n, n3);
            return;
        }
        int n5 = n;
        int n6 = n4;
        for (int i = n; i < n2; ++i) {
            dArray2[i] = n6 >= n2 || n5 < n4 && dArray[n5] <= dArray[n6] ? dArray[n5++] : dArray[n6++];
        }
    }

    private static void mergeSort1(double[] dArray, double[] dArray2, int n, int n2, DoubleComparator doubleComparator) {
        int n3 = n2 - n;
        if (n3 < 7) {
            for (int i = n; i < n2; ++i) {
                for (int j = i; j > n && doubleComparator.compare(dArray2[j - 1], dArray2[j]) > 0; --j) {
                    Sorting.swap(dArray2, j, j - 1);
                }
            }
            return;
        }
        int n4 = (n + n2) / 2;
        Sorting.mergeSort1(dArray2, dArray, n, n4, doubleComparator);
        Sorting.mergeSort1(dArray2, dArray, n4, n2, doubleComparator);
        if (doubleComparator.compare(dArray[n4 - 1], dArray[n4]) <= 0) {
            System.arraycopy(dArray, n, dArray2, n, n3);
            return;
        }
        int n5 = n;
        int n6 = n4;
        for (int i = n; i < n2; ++i) {
            dArray2[i] = n6 >= n2 || n5 < n4 && doubleComparator.compare(dArray[n5], dArray[n6]) <= 0 ? dArray[n5++] : dArray[n6++];
        }
    }

    private static void mergeSort1(float[] fArray, float[] fArray2, int n, int n2) {
        int n3 = n2 - n;
        if (n3 < 7) {
            for (int i = n; i < n2; ++i) {
                for (int j = i; j > n && fArray2[j - 1] > fArray2[j]; --j) {
                    Sorting.swap(fArray2, j, j - 1);
                }
            }
            return;
        }
        int n4 = (n + n2) / 2;
        Sorting.mergeSort1(fArray2, fArray, n, n4);
        Sorting.mergeSort1(fArray2, fArray, n4, n2);
        if (fArray[n4 - 1] <= fArray[n4]) {
            System.arraycopy(fArray, n, fArray2, n, n3);
            return;
        }
        int n5 = n;
        int n6 = n4;
        for (int i = n; i < n2; ++i) {
            fArray2[i] = n6 >= n2 || n5 < n4 && fArray[n5] <= fArray[n6] ? fArray[n5++] : fArray[n6++];
        }
    }

    private static void mergeSort1(float[] fArray, float[] fArray2, int n, int n2, FloatComparator floatComparator) {
        int n3 = n2 - n;
        if (n3 < 7) {
            for (int i = n; i < n2; ++i) {
                for (int j = i; j > n && floatComparator.compare(fArray2[j - 1], fArray2[j]) > 0; --j) {
                    Sorting.swap(fArray2, j, j - 1);
                }
            }
            return;
        }
        int n4 = (n + n2) / 2;
        Sorting.mergeSort1(fArray2, fArray, n, n4, floatComparator);
        Sorting.mergeSort1(fArray2, fArray, n4, n2, floatComparator);
        if (floatComparator.compare(fArray[n4 - 1], fArray[n4]) <= 0) {
            System.arraycopy(fArray, n, fArray2, n, n3);
            return;
        }
        int n5 = n;
        int n6 = n4;
        for (int i = n; i < n2; ++i) {
            fArray2[i] = n6 >= n2 || n5 < n4 && floatComparator.compare(fArray[n5], fArray[n6]) <= 0 ? fArray[n5++] : fArray[n6++];
        }
    }

    private static void mergeSort1(int[] nArray, int[] nArray2, int n, int n2) {
        int n3 = n2 - n;
        if (n3 < 7) {
            for (int i = n; i < n2; ++i) {
                for (int j = i; j > n && nArray2[j - 1] > nArray2[j]; --j) {
                    Sorting.swap(nArray2, j, j - 1);
                }
            }
            return;
        }
        int n4 = (n + n2) / 2;
        Sorting.mergeSort1(nArray2, nArray, n, n4);
        Sorting.mergeSort1(nArray2, nArray, n4, n2);
        if (nArray[n4 - 1] <= nArray[n4]) {
            System.arraycopy(nArray, n, nArray2, n, n3);
            return;
        }
        int n5 = n;
        int n6 = n4;
        for (int i = n; i < n2; ++i) {
            nArray2[i] = n6 >= n2 || n5 < n4 && nArray[n5] <= nArray[n6] ? nArray[n5++] : nArray[n6++];
        }
    }

    private static void mergeSort1(int[] nArray, int[] nArray2, int n, int n2, IntComparator intComparator) {
        int n3 = n2 - n;
        if (n3 < 7) {
            for (int i = n; i < n2; ++i) {
                for (int j = i; j > n && intComparator.compare(nArray2[j - 1], nArray2[j]) > 0; --j) {
                    Sorting.swap(nArray2, j, j - 1);
                }
            }
            return;
        }
        int n4 = (n + n2) / 2;
        Sorting.mergeSort1(nArray2, nArray, n, n4, intComparator);
        Sorting.mergeSort1(nArray2, nArray, n4, n2, intComparator);
        if (intComparator.compare(nArray[n4 - 1], nArray[n4]) <= 0) {
            System.arraycopy(nArray, n, nArray2, n, n3);
            return;
        }
        int n5 = n;
        int n6 = n4;
        for (int i = n; i < n2; ++i) {
            nArray2[i] = n6 >= n2 || n5 < n4 && intComparator.compare(nArray[n5], nArray[n6]) <= 0 ? nArray[n5++] : nArray[n6++];
        }
    }

    private static void mergeSort1(long[] lArray, long[] lArray2, int n, int n2) {
        int n3 = n2 - n;
        if (n3 < 7) {
            for (int i = n; i < n2; ++i) {
                for (int j = i; j > n && lArray2[j - 1] > lArray2[j]; --j) {
                    Sorting.swap(lArray2, j, j - 1);
                }
            }
            return;
        }
        int n4 = (n + n2) / 2;
        Sorting.mergeSort1(lArray2, lArray, n, n4);
        Sorting.mergeSort1(lArray2, lArray, n4, n2);
        if (lArray[n4 - 1] <= lArray[n4]) {
            System.arraycopy(lArray, n, lArray2, n, n3);
            return;
        }
        int n5 = n;
        int n6 = n4;
        for (int i = n; i < n2; ++i) {
            lArray2[i] = n6 >= n2 || n5 < n4 && lArray[n5] <= lArray[n6] ? lArray[n5++] : lArray[n6++];
        }
    }

    private static void mergeSort1(long[] lArray, long[] lArray2, int n, int n2, LongComparator longComparator) {
        int n3 = n2 - n;
        if (n3 < 7) {
            for (int i = n; i < n2; ++i) {
                for (int j = i; j > n && longComparator.compare(lArray2[j - 1], lArray2[j]) > 0; --j) {
                    Sorting.swap(lArray2, j, j - 1);
                }
            }
            return;
        }
        int n4 = (n + n2) / 2;
        Sorting.mergeSort1(lArray2, lArray, n, n4, longComparator);
        Sorting.mergeSort1(lArray2, lArray, n4, n2, longComparator);
        if (longComparator.compare(lArray[n4 - 1], lArray[n4]) <= 0) {
            System.arraycopy(lArray, n, lArray2, n, n3);
            return;
        }
        int n5 = n;
        int n6 = n4;
        for (int i = n; i < n2; ++i) {
            lArray2[i] = n6 >= n2 || n5 < n4 && longComparator.compare(lArray[n5], lArray[n6]) <= 0 ? lArray[n5++] : lArray[n6++];
        }
    }

    private static void mergeSort1(short[] sArray, short[] sArray2, int n, int n2) {
        int n3 = n2 - n;
        if (n3 < 7) {
            for (int i = n; i < n2; ++i) {
                for (int j = i; j > n && sArray2[j - 1] > sArray2[j]; --j) {
                    Sorting.swap(sArray2, j, j - 1);
                }
            }
            return;
        }
        int n4 = (n + n2) / 2;
        Sorting.mergeSort1(sArray2, sArray, n, n4);
        Sorting.mergeSort1(sArray2, sArray, n4, n2);
        if (sArray[n4 - 1] <= sArray[n4]) {
            System.arraycopy(sArray, n, sArray2, n, n3);
            return;
        }
        int n5 = n;
        int n6 = n4;
        for (int i = n; i < n2; ++i) {
            sArray2[i] = n6 >= n2 || n5 < n4 && sArray[n5] <= sArray[n6] ? sArray[n5++] : sArray[n6++];
        }
    }

    private static void mergeSort1(short[] sArray, short[] sArray2, int n, int n2, ShortComparator shortComparator) {
        int n3 = n2 - n;
        if (n3 < 7) {
            for (int i = n; i < n2; ++i) {
                for (int j = i; j > n && shortComparator.compare(sArray2[j - 1], sArray2[j]) > 0; --j) {
                    Sorting.swap(sArray2, j, j - 1);
                }
            }
            return;
        }
        int n4 = (n + n2) / 2;
        Sorting.mergeSort1(sArray2, sArray, n, n4, shortComparator);
        Sorting.mergeSort1(sArray2, sArray, n4, n2, shortComparator);
        if (shortComparator.compare(sArray[n4 - 1], sArray[n4]) <= 0) {
            System.arraycopy(sArray, n, sArray2, n, n3);
            return;
        }
        int n5 = n;
        int n6 = n4;
        for (int i = n; i < n2; ++i) {
            sArray2[i] = n6 >= n2 || n5 < n4 && shortComparator.compare(sArray[n5], sArray[n6]) <= 0 ? sArray[n5++] : sArray[n6++];
        }
    }

    private static void mergeSort2(double[] dArray, int n, int n2) {
        Sorting.rangeCheck(dArray.length, n, n2);
        long l = Double.doubleToLongBits(-0.0);
        int n3 = 0;
        int n4 = n;
        int n5 = n2;
        while (n4 < n5) {
            if (dArray[n4] != dArray[n4]) {
                dArray[n4] = dArray[--n5];
                dArray[n5] = Double.NaN;
                continue;
            }
            if (dArray[n4] == 0.0 && Double.doubleToLongBits(dArray[n4]) == l) {
                dArray[n4] = 0.0;
                ++n3;
            }
            ++n4;
        }
        double[] dArray2 = (double[])dArray.clone();
        Sorting.mergeSort1(dArray2, dArray, n, n5);
        if (n3 != 0) {
            int n6 = new DoubleArrayList(dArray).binarySearchFromTo(0.0, n, n5 - 1);
            while (--n6 >= 0 && dArray[n6] == 0.0) {
            }
            for (int i = 0; i < n3; ++i) {
                dArray[++n6] = -0.0;
            }
        }
    }

    private static void mergeSort2(float[] fArray, int n, int n2) {
        Sorting.rangeCheck(fArray.length, n, n2);
        int n3 = Float.floatToIntBits(-0.0f);
        int n4 = 0;
        int n5 = n;
        int n6 = n2;
        while (n5 < n6) {
            if (fArray[n5] != fArray[n5]) {
                fArray[n5] = fArray[--n6];
                fArray[n6] = Float.NaN;
                continue;
            }
            if (fArray[n5] == 0.0f && Float.floatToIntBits(fArray[n5]) == n3) {
                fArray[n5] = 0.0f;
                ++n4;
            }
            ++n5;
        }
        float[] fArray2 = (float[])fArray.clone();
        Sorting.mergeSort1(fArray2, fArray, n, n6);
        if (n4 != 0) {
            int n7 = new FloatArrayList(fArray).binarySearchFromTo(0.0f, n, n6 - 1);
            while (--n7 >= 0 && fArray[n7] == 0.0f) {
            }
            for (int i = 0; i < n4; ++i) {
                fArray[++n7] = -0.0f;
            }
        }
    }

    public static void mergeSortInPlace(int[] nArray, int n, int n2) {
        Sorting.rangeCheck(nArray.length, n, n2);
        int n3 = n2 - n;
        if (n3 < 7) {
            for (int i = n; i < n2; ++i) {
                for (int j = i; j > n && nArray[j - 1] > nArray[j]; --j) {
                    int n4 = nArray[j];
                    nArray[j] = nArray[j - 1];
                    nArray[j - 1] = n4;
                }
            }
            return;
        }
        int n5 = (n + n2) / 2;
        Sorting.mergeSortInPlace(nArray, n, n5);
        Sorting.mergeSortInPlace(nArray, n5, n2);
        if (nArray[n5 - 1] <= nArray[n5]) {
            return;
        }
        Sorting.inplace_merge(nArray, n, n5, n2);
    }

    public static void quickSort(byte[] byArray, int n, int n2, ByteComparator byteComparator) {
        Sorting.rangeCheck(byArray.length, n, n2);
        Sorting.quickSort1(byArray, n, n2 - n, byteComparator);
    }

    public static void quickSort(char[] cArray, int n, int n2, CharComparator charComparator) {
        Sorting.rangeCheck(cArray.length, n, n2);
        Sorting.quickSort1(cArray, n, n2 - n, charComparator);
    }

    public static void quickSort(double[] dArray, int n, int n2, DoubleComparator doubleComparator) {
        Sorting.rangeCheck(dArray.length, n, n2);
        Sorting.quickSort1(dArray, n, n2 - n, doubleComparator);
    }

    public static void quickSort(float[] fArray, int n, int n2, FloatComparator floatComparator) {
        Sorting.rangeCheck(fArray.length, n, n2);
        Sorting.quickSort1(fArray, n, n2 - n, floatComparator);
    }

    public static void quickSort(int[] nArray, int n, int n2, IntComparator intComparator) {
        Sorting.rangeCheck(nArray.length, n, n2);
        Sorting.quickSort1(nArray, n, n2 - n, intComparator);
    }

    public static void quickSort(long[] lArray, int n, int n2, LongComparator longComparator) {
        Sorting.rangeCheck(lArray.length, n, n2);
        Sorting.quickSort1(lArray, n, n2 - n, longComparator);
    }

    public static void quickSort(Object[] objectArray) {
        Sorting.quickSort1(objectArray, 0, objectArray.length);
    }

    public static void quickSort(Object[] objectArray, int n, int n2) {
        Sorting.rangeCheck(objectArray.length, n, n2);
        Sorting.quickSort1(objectArray, n, n2 - n);
    }

    public static void quickSort(Object[] objectArray, int n, int n2, Comparator comparator) {
        Sorting.rangeCheck(objectArray.length, n, n2);
        Sorting.quickSort1(objectArray, n, n2 - n, comparator);
    }

    public static void quickSort(Object[] objectArray, Comparator comparator) {
        Sorting.quickSort1(objectArray, 0, objectArray.length, comparator);
    }

    public static void quickSort(short[] sArray, int n, int n2, ShortComparator shortComparator) {
        Sorting.rangeCheck(sArray.length, n, n2);
        Sorting.quickSort1(sArray, n, n2 - n, shortComparator);
    }

    private static void quickSort1(byte[] byArray, int n, int n2, ByteComparator byteComparator) {
        int n3;
        int n4;
        int n5;
        int n6;
        if (n2 < 7) {
            for (int i = n; i < n2 + n; ++i) {
                for (int j = i; j > n && byteComparator.compare(byArray[j - 1], byArray[j]) > 0; --j) {
                    Sorting.swap(byArray, j, j - 1);
                }
            }
            return;
        }
        int n7 = n + n2 / 2;
        if (n2 > 7) {
            int n8;
            int by = n;
            n6 = n + n2 - 1;
            if (n2 > 40) {
                n5 = n2 / 8;
                n8 = Sorting.med3(byArray, by, by + n5, by + 2 * n5, byteComparator);
                n7 = Sorting.med3(byArray, n7 - n5, n7, n7 + n5, byteComparator);
                n6 = Sorting.med3(byArray, n6 - 2 * n5, n6 - n5, n6, byteComparator);
            }
            n7 = Sorting.med3(byArray, n8, n7, n6, byteComparator);
        }
        byte by = byArray[n7];
        n5 = n6 = n;
        int n9 = n4 = n + n2 - 1;
        while (true) {
            if (n5 <= n4 && (n3 = byteComparator.compare(byArray[n5], by)) <= 0) {
                if (n3 == 0) {
                    Sorting.swap(byArray, n6++, n5);
                }
                ++n5;
                continue;
            }
            while (n4 >= n5 && (n3 = byteComparator.compare(byArray[n4], by)) >= 0) {
                if (n3 == 0) {
                    Sorting.swap(byArray, n4, n9--);
                }
                --n4;
            }
            if (n5 > n4) break;
            Sorting.swap(byArray, n5++, n4--);
        }
        int n10 = n + n2;
        n3 = Math.min(n6 - n, n5 - n6);
        Sorting.vecswap(byArray, n, n5 - n3, n3);
        n3 = Math.min(n9 - n4, n10 - n9 - 1);
        Sorting.vecswap(byArray, n5, n10 - n3, n3);
        n3 = n5 - n6;
        if (n3 > 1) {
            Sorting.quickSort1(byArray, n, n3, byteComparator);
        }
        if ((n3 = n9 - n4) > 1) {
            Sorting.quickSort1(byArray, n10 - n3, n3, byteComparator);
        }
    }

    private static void quickSort1(char[] cArray, int n, int n2, CharComparator charComparator) {
        int n3;
        int n4;
        int n5;
        int n6;
        if (n2 < 7) {
            for (int i = n; i < n2 + n; ++i) {
                for (int j = i; j > n && charComparator.compare(cArray[j - 1], cArray[j]) > 0; --j) {
                    Sorting.swap(cArray, j, j - 1);
                }
            }
            return;
        }
        int n7 = n + n2 / 2;
        if (n2 > 7) {
            int n8;
            int c = n;
            n6 = n + n2 - 1;
            if (n2 > 40) {
                n5 = n2 / 8;
                n8 = Sorting.med3(cArray, c, c + n5, c + 2 * n5, charComparator);
                n7 = Sorting.med3(cArray, n7 - n5, n7, n7 + n5, charComparator);
                n6 = Sorting.med3(cArray, n6 - 2 * n5, n6 - n5, n6, charComparator);
            }
            n7 = Sorting.med3(cArray, n8, n7, n6, charComparator);
        }
        char c = cArray[n7];
        n5 = n6 = n;
        int n9 = n4 = n + n2 - 1;
        while (true) {
            if (n5 <= n4 && (n3 = charComparator.compare(cArray[n5], c)) <= 0) {
                if (n3 == 0) {
                    Sorting.swap(cArray, n6++, n5);
                }
                ++n5;
                continue;
            }
            while (n4 >= n5 && (n3 = charComparator.compare(cArray[n4], c)) >= 0) {
                if (n3 == 0) {
                    Sorting.swap(cArray, n4, n9--);
                }
                --n4;
            }
            if (n5 > n4) break;
            Sorting.swap(cArray, n5++, n4--);
        }
        int n10 = n + n2;
        n3 = Math.min(n6 - n, n5 - n6);
        Sorting.vecswap(cArray, n, n5 - n3, n3);
        n3 = Math.min(n9 - n4, n10 - n9 - 1);
        Sorting.vecswap(cArray, n5, n10 - n3, n3);
        n3 = n5 - n6;
        if (n3 > 1) {
            Sorting.quickSort1(cArray, n, n3, charComparator);
        }
        if ((n3 = n9 - n4) > 1) {
            Sorting.quickSort1(cArray, n10 - n3, n3, charComparator);
        }
    }

    private static void quickSort1(double[] dArray, int n, int n2, DoubleComparator doubleComparator) {
        int n3;
        int n4;
        int n5;
        if (n2 < 7) {
            for (int i = n; i < n2 + n; ++i) {
                for (int j = i; j > n && doubleComparator.compare(dArray[j - 1], dArray[j]) > 0; --j) {
                    Sorting.swap(dArray, j, j - 1);
                }
            }
            return;
        }
        int n6 = n + n2 / 2;
        if (n2 > 7) {
            int n7 = n;
            int n8 = n + n2 - 1;
            if (n2 > 40) {
                n5 = n2 / 8;
                n7 = Sorting.med3(dArray, n7, n7 + n5, n7 + 2 * n5, doubleComparator);
                n6 = Sorting.med3(dArray, n6 - n5, n6, n6 + n5, doubleComparator);
                n8 = Sorting.med3(dArray, n8 - 2 * n5, n8 - n5, n8, doubleComparator);
            }
            n6 = Sorting.med3(dArray, n7, n6, n8, doubleComparator);
        }
        double d = dArray[n6];
        int n9 = n5 = n;
        int n10 = n4 = n + n2 - 1;
        while (true) {
            if (n9 <= n4 && (n3 = doubleComparator.compare(dArray[n9], d)) <= 0) {
                if (n3 == 0) {
                    Sorting.swap(dArray, n5++, n9);
                }
                ++n9;
                continue;
            }
            while (n4 >= n9 && (n3 = doubleComparator.compare(dArray[n4], d)) >= 0) {
                if (n3 == 0) {
                    Sorting.swap(dArray, n4, n10--);
                }
                --n4;
            }
            if (n9 > n4) break;
            Sorting.swap(dArray, n9++, n4--);
        }
        int n11 = n + n2;
        n3 = Math.min(n5 - n, n9 - n5);
        Sorting.vecswap(dArray, n, n9 - n3, n3);
        n3 = Math.min(n10 - n4, n11 - n10 - 1);
        Sorting.vecswap(dArray, n9, n11 - n3, n3);
        n3 = n9 - n5;
        if (n3 > 1) {
            Sorting.quickSort1(dArray, n, n3, doubleComparator);
        }
        if ((n3 = n10 - n4) > 1) {
            Sorting.quickSort1(dArray, n11 - n3, n3, doubleComparator);
        }
    }

    private static void quickSort1(float[] fArray, int n, int n2, FloatComparator floatComparator) {
        int n3;
        int n4;
        int n5;
        int n6;
        if (n2 < 7) {
            for (int i = n; i < n2 + n; ++i) {
                for (int j = i; j > n && floatComparator.compare(fArray[j - 1], fArray[j]) > 0; --j) {
                    Sorting.swap(fArray, j, j - 1);
                }
            }
            return;
        }
        int n7 = n + n2 / 2;
        if (n2 > 7) {
            int n8 = n;
            n6 = n + n2 - 1;
            if (n2 > 40) {
                n5 = n2 / 8;
                n8 = Sorting.med3(fArray, n8, n8 + n5, n8 + 2 * n5, floatComparator);
                n7 = Sorting.med3(fArray, n7 - n5, n7, n7 + n5, floatComparator);
                n6 = Sorting.med3(fArray, n6 - 2 * n5, n6 - n5, n6, floatComparator);
            }
            n7 = Sorting.med3(fArray, n8, n7, n6, floatComparator);
        }
        float f = fArray[n7];
        n5 = n6 = n;
        int n9 = n4 = n + n2 - 1;
        while (true) {
            if (n5 <= n4 && (n3 = floatComparator.compare(fArray[n5], f)) <= 0) {
                if (n3 == 0) {
                    Sorting.swap(fArray, n6++, n5);
                }
                ++n5;
                continue;
            }
            while (n4 >= n5 && (n3 = floatComparator.compare(fArray[n4], f)) >= 0) {
                if (n3 == 0) {
                    Sorting.swap(fArray, n4, n9--);
                }
                --n4;
            }
            if (n5 > n4) break;
            Sorting.swap(fArray, n5++, n4--);
        }
        int n10 = n + n2;
        n3 = Math.min(n6 - n, n5 - n6);
        Sorting.vecswap(fArray, n, n5 - n3, n3);
        n3 = Math.min(n9 - n4, n10 - n9 - 1);
        Sorting.vecswap(fArray, n5, n10 - n3, n3);
        n3 = n5 - n6;
        if (n3 > 1) {
            Sorting.quickSort1(fArray, n, n3, floatComparator);
        }
        if ((n3 = n9 - n4) > 1) {
            Sorting.quickSort1(fArray, n10 - n3, n3, floatComparator);
        }
    }

    private static void quickSort1(int[] nArray, int n, int n2, IntComparator intComparator) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        if (n2 < 7) {
            for (int i = n; i < n2 + n; ++i) {
                for (int j = i; j > n && intComparator.compare(nArray[j - 1], nArray[j]) > 0; --j) {
                    Sorting.swap(nArray, j, j - 1);
                }
            }
            return;
        }
        int n8 = n + n2 / 2;
        if (n2 > 7) {
            n7 = n;
            n6 = n + n2 - 1;
            if (n2 > 40) {
                n5 = n2 / 8;
                n7 = Sorting.med3(nArray, n7, n7 + n5, n7 + 2 * n5, intComparator);
                n8 = Sorting.med3(nArray, n8 - n5, n8, n8 + n5, intComparator);
                n6 = Sorting.med3(nArray, n6 - 2 * n5, n6 - n5, n6, intComparator);
            }
            n8 = Sorting.med3(nArray, n7, n8, n6, intComparator);
        }
        n7 = nArray[n8];
        n5 = n6 = n;
        int n9 = n4 = n + n2 - 1;
        while (true) {
            if (n5 <= n4 && (n3 = intComparator.compare(nArray[n5], n7)) <= 0) {
                if (n3 == 0) {
                    Sorting.swap(nArray, n6++, n5);
                }
                ++n5;
                continue;
            }
            while (n4 >= n5 && (n3 = intComparator.compare(nArray[n4], n7)) >= 0) {
                if (n3 == 0) {
                    Sorting.swap(nArray, n4, n9--);
                }
                --n4;
            }
            if (n5 > n4) break;
            Sorting.swap(nArray, n5++, n4--);
        }
        int n10 = n + n2;
        n3 = Math.min(n6 - n, n5 - n6);
        Sorting.vecswap(nArray, n, n5 - n3, n3);
        n3 = Math.min(n9 - n4, n10 - n9 - 1);
        Sorting.vecswap(nArray, n5, n10 - n3, n3);
        n3 = n5 - n6;
        if (n3 > 1) {
            Sorting.quickSort1(nArray, n, n3, intComparator);
        }
        if ((n3 = n9 - n4) > 1) {
            Sorting.quickSort1(nArray, n10 - n3, n3, intComparator);
        }
    }

    private static void quickSort1(long[] lArray, int n, int n2, LongComparator longComparator) {
        int n3;
        int n4;
        int n5;
        if (n2 < 7) {
            for (int i = n; i < n2 + n; ++i) {
                for (int j = i; j > n && longComparator.compare(lArray[j - 1], lArray[j]) > 0; --j) {
                    Sorting.swap(lArray, j, j - 1);
                }
            }
            return;
        }
        int n6 = n + n2 / 2;
        if (n2 > 7) {
            int n7 = n;
            int n8 = n + n2 - 1;
            if (n2 > 40) {
                n5 = n2 / 8;
                n7 = Sorting.med3(lArray, n7, n7 + n5, n7 + 2 * n5, longComparator);
                n6 = Sorting.med3(lArray, n6 - n5, n6, n6 + n5, longComparator);
                n8 = Sorting.med3(lArray, n8 - 2 * n5, n8 - n5, n8, longComparator);
            }
            n6 = Sorting.med3(lArray, n7, n6, n8, longComparator);
        }
        long l = lArray[n6];
        int n9 = n5 = n;
        int n10 = n4 = n + n2 - 1;
        while (true) {
            if (n9 <= n4 && (n3 = longComparator.compare(lArray[n9], l)) <= 0) {
                if (n3 == 0) {
                    Sorting.swap(lArray, n5++, n9);
                }
                ++n9;
                continue;
            }
            while (n4 >= n9 && (n3 = longComparator.compare(lArray[n4], l)) >= 0) {
                if (n3 == 0) {
                    Sorting.swap(lArray, n4, n10--);
                }
                --n4;
            }
            if (n9 > n4) break;
            Sorting.swap(lArray, n9++, n4--);
        }
        int n11 = n + n2;
        n3 = Math.min(n5 - n, n9 - n5);
        Sorting.vecswap(lArray, n, n9 - n3, n3);
        n3 = Math.min(n10 - n4, n11 - n10 - 1);
        Sorting.vecswap(lArray, n9, n11 - n3, n3);
        n3 = n9 - n5;
        if (n3 > 1) {
            Sorting.quickSort1(lArray, n, n3, longComparator);
        }
        if ((n3 = n10 - n4) > 1) {
            Sorting.quickSort1(lArray, n11 - n3, n3, longComparator);
        }
    }

    private static void quickSort1(Object[] objectArray, int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        if (n2 < 7) {
            for (int i = n; i < n2 + n; ++i) {
                for (int j = i; j > n && ((Comparable)objectArray[j - 1]).compareTo((Comparable)objectArray[j]) > 0; --j) {
                    Sorting.swap(objectArray, j, j - 1);
                }
            }
            return;
        }
        int n7 = n + n2 / 2;
        if (n2 > 7) {
            int n8 = n;
            n6 = n + n2 - 1;
            if (n2 > 40) {
                n5 = n2 / 8;
                n8 = Sorting.med3(objectArray, n8, n8 + n5, n8 + 2 * n5);
                n7 = Sorting.med3(objectArray, n7 - n5, n7, n7 + n5);
                n6 = Sorting.med3(objectArray, n6 - 2 * n5, n6 - n5, n6);
            }
            n7 = Sorting.med3(objectArray, n8, n7, n6);
        }
        Comparable comparable = (Comparable)objectArray[n7];
        n5 = n6 = n;
        int n9 = n4 = n + n2 - 1;
        while (true) {
            if (n5 <= n4 && (n3 = ((Comparable)objectArray[n5]).compareTo(comparable)) <= 0) {
                if (n3 == 0) {
                    Sorting.swap(objectArray, n6++, n5);
                }
                ++n5;
                continue;
            }
            while (n4 >= n5 && (n3 = ((Comparable)objectArray[n4]).compareTo(comparable)) >= 0) {
                if (n3 == 0) {
                    Sorting.swap(objectArray, n4, n9--);
                }
                --n4;
            }
            if (n5 > n4) break;
            Sorting.swap(objectArray, n5++, n4--);
        }
        int n10 = n + n2;
        n3 = Math.min(n6 - n, n5 - n6);
        Sorting.vecswap(objectArray, n, n5 - n3, n3);
        n3 = Math.min(n9 - n4, n10 - n9 - 1);
        Sorting.vecswap(objectArray, n5, n10 - n3, n3);
        n3 = n5 - n6;
        if (n3 > 1) {
            Sorting.quickSort1(objectArray, n, n3);
        }
        if ((n3 = n9 - n4) > 1) {
            Sorting.quickSort1(objectArray, n10 - n3, n3);
        }
    }

    private static void quickSort1(Object[] objectArray, int n, int n2, Comparator comparator) {
        int n3;
        int n4;
        int n5;
        int n6;
        if (n2 < 7) {
            for (int i = n; i < n2 + n; ++i) {
                for (int j = i; j > n && comparator.compare(objectArray[j - 1], objectArray[j]) > 0; --j) {
                    Sorting.swap(objectArray, j, j - 1);
                }
            }
            return;
        }
        int n7 = n + n2 / 2;
        if (n2 > 7) {
            int n8 = n;
            n6 = n + n2 - 1;
            if (n2 > 40) {
                n5 = n2 / 8;
                n8 = Sorting.med3(objectArray, n8, n8 + n5, n8 + 2 * n5, comparator);
                n7 = Sorting.med3(objectArray, n7 - n5, n7, n7 + n5, comparator);
                n6 = Sorting.med3(objectArray, n6 - 2 * n5, n6 - n5, n6, comparator);
            }
            n7 = Sorting.med3(objectArray, n8, n7, n6, comparator);
        }
        Object object = objectArray[n7];
        n5 = n6 = n;
        int n9 = n4 = n + n2 - 1;
        while (true) {
            if (n5 <= n4 && (n3 = comparator.compare(objectArray[n5], object)) <= 0) {
                if (n3 == 0) {
                    Sorting.swap(objectArray, n6++, n5);
                }
                ++n5;
                continue;
            }
            while (n4 >= n5 && (n3 = comparator.compare(objectArray[n4], object)) >= 0) {
                if (n3 == 0) {
                    Sorting.swap(objectArray, n4, n9--);
                }
                --n4;
            }
            if (n5 > n4) break;
            Sorting.swap(objectArray, n5++, n4--);
        }
        int n10 = n + n2;
        n3 = Math.min(n6 - n, n5 - n6);
        Sorting.vecswap(objectArray, n, n5 - n3, n3);
        n3 = Math.min(n9 - n4, n10 - n9 - 1);
        Sorting.vecswap(objectArray, n5, n10 - n3, n3);
        n3 = n5 - n6;
        if (n3 > 1) {
            Sorting.quickSort1(objectArray, n, n3, comparator);
        }
        if ((n3 = n9 - n4) > 1) {
            Sorting.quickSort1(objectArray, n10 - n3, n3, comparator);
        }
    }

    private static void quickSort1(short[] sArray, int n, int n2, ShortComparator shortComparator) {
        int n3;
        int n4;
        int n5;
        int n6;
        if (n2 < 7) {
            for (int i = n; i < n2 + n; ++i) {
                for (int j = i; j > n && shortComparator.compare(sArray[j - 1], sArray[j]) > 0; --j) {
                    Sorting.swap(sArray, j, j - 1);
                }
            }
            return;
        }
        int n7 = n + n2 / 2;
        if (n2 > 7) {
            int n8;
            int s = n;
            n6 = n + n2 - 1;
            if (n2 > 40) {
                n5 = n2 / 8;
                n8 = Sorting.med3(sArray, s, s + n5, s + 2 * n5, shortComparator);
                n7 = Sorting.med3(sArray, n7 - n5, n7, n7 + n5, shortComparator);
                n6 = Sorting.med3(sArray, n6 - 2 * n5, n6 - n5, n6, shortComparator);
            }
            n7 = Sorting.med3(sArray, n8, n7, n6, shortComparator);
        }
        short s = sArray[n7];
        n5 = n6 = n;
        int n9 = n4 = n + n2 - 1;
        while (true) {
            if (n5 <= n4 && (n3 = shortComparator.compare(sArray[n5], s)) <= 0) {
                if (n3 == 0) {
                    Sorting.swap(sArray, n6++, n5);
                }
                ++n5;
                continue;
            }
            while (n4 >= n5 && (n3 = shortComparator.compare(sArray[n4], s)) >= 0) {
                if (n3 == 0) {
                    Sorting.swap(sArray, n4, n9--);
                }
                --n4;
            }
            if (n5 > n4) break;
            Sorting.swap(sArray, n5++, n4--);
        }
        int n10 = n + n2;
        n3 = Math.min(n6 - n, n5 - n6);
        Sorting.vecswap(sArray, n, n5 - n3, n3);
        n3 = Math.min(n9 - n4, n10 - n9 - 1);
        Sorting.vecswap(sArray, n5, n10 - n3, n3);
        n3 = n5 - n6;
        if (n3 > 1) {
            Sorting.quickSort1(sArray, n, n3, shortComparator);
        }
        if ((n3 = n9 - n4) > 1) {
            Sorting.quickSort1(sArray, n10 - n3, n3, shortComparator);
        }
    }

    private static void rangeCheck(int n, int n2, int n3) {
        if (n2 > n3) {
            throw new IllegalArgumentException("fromIndex(" + n2 + ") > toIndex(" + n3 + ")");
        }
        if (n2 < 0) {
            throw new ArrayIndexOutOfBoundsException(n2);
        }
        if (n3 > n) {
            throw new ArrayIndexOutOfBoundsException(n3);
        }
    }

    private static void swap(byte[] byArray, int n, int n2) {
        byte by = byArray[n];
        byArray[n] = byArray[n2];
        byArray[n2] = by;
    }

    private static void swap(char[] cArray, int n, int n2) {
        char c = cArray[n];
        cArray[n] = cArray[n2];
        cArray[n2] = c;
    }

    private static void swap(double[] dArray, int n, int n2) {
        double d = dArray[n];
        dArray[n] = dArray[n2];
        dArray[n2] = d;
    }

    private static void swap(float[] fArray, int n, int n2) {
        float f = fArray[n];
        fArray[n] = fArray[n2];
        fArray[n2] = f;
    }

    private static void swap(int[] nArray, int n, int n2) {
        int n3 = nArray[n];
        nArray[n] = nArray[n2];
        nArray[n2] = n3;
    }

    private static void swap(long[] lArray, int n, int n2) {
        long l = lArray[n];
        lArray[n] = lArray[n2];
        lArray[n2] = l;
    }

    private static void swap(Object[] objectArray, int n, int n2) {
        Object object = objectArray[n];
        objectArray[n] = objectArray[n2];
        objectArray[n2] = object;
    }

    private static void swap(short[] sArray, int n, int n2) {
        short s = sArray[n];
        sArray[n] = sArray[n2];
        sArray[n2] = s;
    }

    private static void vecswap(byte[] byArray, int n, int n2, int n3) {
        int n4 = 0;
        while (n4 < n3) {
            Sorting.swap(byArray, n, n2);
            ++n4;
            ++n;
            ++n2;
        }
    }

    private static void vecswap(char[] cArray, int n, int n2, int n3) {
        int n4 = 0;
        while (n4 < n3) {
            Sorting.swap(cArray, n, n2);
            ++n4;
            ++n;
            ++n2;
        }
    }

    private static void vecswap(double[] dArray, int n, int n2, int n3) {
        int n4 = 0;
        while (n4 < n3) {
            Sorting.swap(dArray, n, n2);
            ++n4;
            ++n;
            ++n2;
        }
    }

    private static void vecswap(float[] fArray, int n, int n2, int n3) {
        int n4 = 0;
        while (n4 < n3) {
            Sorting.swap(fArray, n, n2);
            ++n4;
            ++n;
            ++n2;
        }
    }

    private static void vecswap(int[] nArray, int n, int n2, int n3) {
        int n4 = 0;
        while (n4 < n3) {
            Sorting.swap(nArray, n, n2);
            ++n4;
            ++n;
            ++n2;
        }
    }

    private static void vecswap(long[] lArray, int n, int n2, int n3) {
        int n4 = 0;
        while (n4 < n3) {
            Sorting.swap(lArray, n, n2);
            ++n4;
            ++n;
            ++n2;
        }
    }

    private static void vecswap(Object[] objectArray, int n, int n2, int n3) {
        int n4 = 0;
        while (n4 < n3) {
            Sorting.swap(objectArray, n, n2);
            ++n4;
            ++n;
            ++n2;
        }
    }

    private static void vecswap(short[] sArray, int n, int n2, int n3) {
        int n4 = 0;
        while (n4 < n3) {
            Sorting.swap(sArray, n, n2);
            ++n4;
            ++n;
            ++n2;
        }
    }
}

