/*
 * Decompiled with CFR 0.152.
 */
package dmLab.classifier.adx.ruleSet;

import dmLab.array.FArray;
import dmLab.array.functions.DiscFunctions;
import dmLab.classifier.adx.ADXParams;
import dmLab.classifier.adx.complex.Complex;
import dmLab.classifier.adx.complex.complexLinks.ComplexLink;
import dmLab.classifier.adx.complex.complexLinks.ComplexLinks;
import dmLab.classifier.adx.ruleSet.RuleSet;
import dmLab.classifier.adx.selector.SelectorList;
import dmLab.utils.ArrayUtils;
import dmLab.utils.list.ObjectList;
import java.util.Arrays;

public final class SelectRules {
    public final void selectMinFinalRuleSet_fast(RuleSet ruleSet, FArray array, SelectorList selectorsList, ADXParams adxParams, int finalBeam) {
        Object object;
        int eventsNumber = array.rowsNumber();
        ruleSet.createLinks(adxParams);
        RuleSet ruleSet2 = ruleSet;
        ComplexLinks links = ruleSet2.complexLinks;
        int[] posEvents = new int[eventsNumber];
        int decisionId = array.getDecAttrIdx();
        float decValue = array.getDecValues()[ruleSet.decValIndex];
        int posNumber = 0;
        int negNumber = 0;
        int i = 0;
        while (i < eventsNumber) {
            if (array.readValue(decisionId, i) == decValue) {
                posEvents[i] = 1;
                ++posNumber;
            } else {
                posEvents[i] = -1;
                ++negNumber;
            }
            ++i;
        }
        int maxEventsForSelection = adxParams.maxEventsForSelection;
        int size = posEvents.length;
        if (posEvents.length > maxEventsForSelection) {
            double minProb = (double)(size - maxEventsForSelection) / (double)size;
            int i2 = 0;
            while (i2 < size) {
                if (Math.random() < minProb) {
                    if (posEvents[i2] == 1) {
                        --posNumber;
                    } else if (posEvents[i2] == -1) {
                        --negNumber;
                    }
                    posEvents[i2] = 0;
                }
                ++i2;
            }
        }
        int rulesNumber = links.size();
        int addedRules = 0;
        links.sort();
        links.disableAll();
        links.calcGlobalParams$4379dc3a();
        double globalScoreIndex = SelectRules.scoreIndex$2a44e1a7(array, selectorsList, links, adxParams, posEvents, posNumber, negNumber);
        int i3 = rulesNumber - 1;
        while (i3 >= 0) {
            double d;
            links.enable(i3);
            links.calcGlobalParams$4379dc3a();
            double scoreIndex = SelectRules.scoreIndex$2a44e1a7(array, selectorsList, links, adxParams, posEvents, posNumber, negNumber);
            if (d >= globalScoreIndex) {
                globalScoreIndex = scoreIndex;
                if (++addedRules == finalBeam) {
                    break;
                }
            } else {
                links.disable(i3);
            }
            --i3;
        }
        ruleSet2 = object;
        ruleSet2.complexLinks.initIterator(false);
        while ((object = ruleSet2.complexLinks.getNext()) != null) {
            ruleSet2.complexSetArray[((ComplexLink)object).setIndex].removeComplex(((ComplexLink)object).complexIndex);
        }
        object = ruleSet2;
        int n = 0;
        while (n < ((RuleSet)object).complexSetArray.length) {
            if (((RuleSet)object).complexSetArray[n] != null) {
                ((RuleSet)object).complexSetArray[n].trimList();
            }
            ++n;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static double scoreIndex$2a44e1a7(FArray array, SelectorList selectorsList, ComplexLinks links, ADXParams adxParams, int[] posEvents, int posNumber, int negNumber) {
        void var3_3;
        double posScore = 0.0;
        double negScore = 0.0;
        int i = 0;
        while (i < posEvents.length) {
            if (posEvents[i] != 0) {
                double score = links.calcScore(selectorsList, array, i, adxParams);
                if (posEvents[i] == 1) {
                    posScore += score;
                } else if (posEvents[i] == -1) {
                    negScore += score;
                }
            }
            ++i;
        }
        double d = DiscFunctions.calc((float)(posScore / (double)posNumber), (float)(negScore / (double)negNumber), var3_3.scoreQ);
        return d;
    }

    /*
     * WARNING - void declaration
     */
    public static int selectFinalRuleSet(RuleSet ruleSet, ADXParams adxParams, int finalBeam) {
        int rules = 0;
        int removed = 0;
        int i2 = 0;
        while (i2 < ruleSet.complexSetArray.length) {
            if (ruleSet.complexSetArray[i2] != null) {
                rules += ruleSet.complexSetArray[i2].size();
            }
            ++i2;
        }
        if (rules <= finalBeam) {
            removed = 0 + ruleSet.deleteComplexesPosLessNeg();
        } else {
            int n = adxParams.qMethodFinal;
            int n2 = finalBeam;
            RuleSet i2 = ruleSet;
            double[] dArray = new double[n2];
            Arrays.fill(dArray, Double.NEGATIVE_INFINITY);
            int n3 = dArray.length;
            int n4 = 0;
            while (n4 < i2.complexSetArray.length) {
                if (i2.complexSetArray[n4] != null) {
                    int n5 = i2.complexSetArray[n4].size();
                    int n6 = 0;
                    while (n6 < n5) {
                        Complex complex = i2.complexSetArray[n4].getComplex(n6);
                        if (complex.reproduce) {
                            double d = complex.calcQuality(n);
                            if (n3 > 0) {
                                dArray[--n3] = d;
                            } else if (dArray[0] < d) {
                                dArray[0] = d;
                                Arrays.sort(dArray);
                            }
                        }
                        ++n6;
                    }
                }
                ++n4;
            }
            if (n3 > 0) {
                Arrays.sort(dArray);
            }
            double significantQ = dArray[n3];
            ObjectList minQualityLinks = new ObjectList();
            int i3 = 0;
            while (i3 < ruleSet.complexSetArray.length) {
                if (ruleSet.complexSetArray[i3] != null) {
                    int setSize = ruleSet.complexSetArray[i3].size();
                    int j = 0;
                    while (j < setSize) {
                        double d;
                        Complex complex = ruleSet.complexSetArray[i3].getComplex(j);
                        double complexQuality = complex.calcQuality(adxParams.qMethodFinal);
                        if (d < significantQ) {
                            ruleSet.complexSetArray[i3].removeComplex(j);
                            ++removed;
                        } else if (complexQuality == significantQ) {
                            minQualityLinks.add(new ComplexLink(complex, i3, j, complexQuality));
                        }
                        ++j;
                    }
                }
                ++i3;
            }
            if (finalBeam < rules - removed) {
                void var2_2;
                void var3_3;
                void toThrow = var3_3 - removed - var2_2;
                int[] throwArray = new int[minQualityLinks.size()];
                ArrayUtils arrayUtils = new ArrayUtils();
                arrayUtils.randomFill(throwArray, (int)toThrow, 1, 0);
                int i4 = 0;
                while (i4 < throwArray.length) {
                    if (throwArray[i4] == 1) {
                        ComplexLink link = (ComplexLink)minQualityLinks.get(i4);
                        ruleSet.complexSetArray[link.setIndex].removeComplex(link.complexIndex);
                        ++removed;
                    }
                    ++i4;
                }
            }
        }
        int i5 = 0;
        while (i5 < ruleSet.complexSetArray.length) {
            if (ruleSet.complexSetArray[i5] != null) {
                ruleSet.complexSetArray[i5].trimList();
                if (ruleSet.complexSetArray[i5].size() == 0) {
                    ruleSet.complexSetArray[i5] = null;
                }
            }
            ++i5;
        }
        return removed;
    }
}

