/*
 * Decompiled with CFR 0.152.
 */
package weka.core.matrix;

import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.core.matrix.Matrix;

public class LinearRegression
implements RevisionHandler {
    protected double[] m_Coefficients = null;

    public LinearRegression(Matrix a, Matrix y, double ridge) {
        this.calculate(a, y, ridge);
    }

    public LinearRegression(Matrix a, Matrix y, double[] w, double ridge) {
        if (w.length != a.getRowDimension()) {
            throw new IllegalArgumentException("Incorrect number of weights provided");
        }
        Matrix weightedThis = new Matrix(a.getRowDimension(), a.getColumnDimension());
        Matrix weightedDep = new Matrix(a.getRowDimension(), 1);
        int i = 0;
        while (i < w.length) {
            double sqrt_weight = Math.sqrt(w[i]);
            int j = 0;
            while (j < a.getColumnDimension()) {
                weightedThis.set(i, j, a.get(i, j) * sqrt_weight);
                ++j;
            }
            weightedDep.set(i, 0, y.get(i, 0) * sqrt_weight);
            ++i;
        }
        this.calculate(weightedThis, weightedDep, ridge);
    }

    protected void calculate(Matrix a, Matrix y, double ridge) {
        if (y.getColumnDimension() > 1) {
            throw new IllegalArgumentException("Only one dependent variable allowed");
        }
        int nc = a.getColumnDimension();
        this.m_Coefficients = new double[nc];
        Matrix ss = LinearRegression.aTa(a);
        Matrix bb = LinearRegression.aTy(a, y);
        boolean success = true;
        do {
            Matrix ssWithRidge = ss.copy();
            int i = 0;
            while (i < nc) {
                ssWithRidge.set(i, i, ssWithRidge.get(i, i) + ridge);
                ++i;
            }
            try {
                Matrix solution = ssWithRidge.solve(bb);
                i = 0;
                while (i < nc) {
                    this.m_Coefficients[i] = solution.get(i, 0);
                    ++i;
                }
                success = true;
            }
            catch (Exception ex) {
                ridge *= 10.0;
                success = false;
            }
        } while (!success);
    }

    private static Matrix aTa(Matrix a) {
        int cols = a.getColumnDimension();
        double[][] A = a.getArray();
        Matrix x = new Matrix(cols, cols);
        double[][] X = x.getArray();
        double[] Acol = new double[a.getRowDimension()];
        int col1 = 0;
        while (col1 < cols) {
            int row = 0;
            while (row < Acol.length) {
                Acol[row] = A[row][col1];
                ++row;
            }
            double[] Xrow = X[col1];
            int row2 = 0;
            while (row2 < Acol.length) {
                double[] Arow = A[row2];
                int col2 = col1;
                while (col2 < Xrow.length) {
                    int n = col2;
                    Xrow[n] = Xrow[n] + Acol[row2] * Arow[col2];
                    ++col2;
                }
                ++row2;
            }
            int col2 = col1 + 1;
            while (col2 < Xrow.length) {
                X[col2][col1] = Xrow[col2];
                ++col2;
            }
            ++col1;
        }
        return x;
    }

    private static Matrix aTy(Matrix a, Matrix y) {
        double[][] A = a.getArray();
        double[][] Y = y.getArray();
        Matrix x = new Matrix(a.getColumnDimension(), 1);
        double[][] X = x.getArray();
        int row = 0;
        while (row < A.length) {
            double[] Arow = A[row];
            double[] Yrow = Y[row];
            int col = 0;
            while (col < Arow.length) {
                double[] dArray = X[col];
                dArray[0] = dArray[0] + Arow[col] * Yrow[0];
                ++col;
            }
            ++row;
        }
        return x;
    }

    public final double[] getCoefficients() {
        return this.m_Coefficients;
    }

    public String toString() {
        return Utils.arrayToString(this.getCoefficients());
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 9768 $");
    }
}

