/*
 * Decompiled with CFR 0.152.
 */
package dmLab.mcfs.mcfsEngine.framework;

import dmLab.array.FArray;
import dmLab.classifier.Classifier;
import dmLab.gui.chartPanel.ChartFrame;
import dmLab.gui.chartPanel.DataSeries;
import dmLab.mcfs.MCFSParams;
import dmLab.mcfs.attributesID.AttributesID;
import dmLab.mcfs.attributesRI.AttributesRI;
import dmLab.mcfs.attributesRI.Ranking;
import dmLab.mcfs.attributesRI.measuresRI.ADXRIMeasure;
import dmLab.mcfs.attributesRI.measuresRI.ClassifiersMeasure;
import dmLab.mcfs.attributesRI.measuresRI.ImportanceMeasure;
import dmLab.mcfs.attributesRI.measuresRI.J48RIMeasure;
import dmLab.mcfs.attributesRI.measuresRI.NodesMeasure;
import dmLab.mcfs.attributesRI.measuresRI.ProjectionMeasure;
import dmLab.mcfs.attributesRI.measuresRI.RINormMeasure;
import dmLab.mcfs.attributesRI.measuresRI.SliqRIMeasure;
import dmLab.mcfs.cutoffMethods.Cutoff;
import dmLab.utils.ArrayUtils;
import dmLab.utils.MathUtils;
import dmLab.utils.ProgressBar;
import dmLab.utils.cmatrix.ConfusionMatrix;
import dmLab.utils.dataframe.DataFrame;
import dmLab.utils.list.FloatList;
import dmLab.utils.statFunctions.LinearRegression;
import dmLab.utils.statList.StatsList;
import java.awt.HeadlessException;
import java.util.ArrayList;

public final class GlobalStats {
    private ConfusionMatrix confusionMatrix;
    private ChartFrame distanceChart = null;
    private LinearRegression myLinearRegression;
    private AttributesRI[] attrRI;
    private AttributesID attrID;
    private StatsList splitsStats;
    private Cutoff cutoff;
    private MCFSParams myMCFSParams;
    private FloatList distanceList = new FloatList();
    private FloatList commonPartList = new FloatList();
    private FloatList mAvgList = new FloatList();
    private FloatList betaList = new FloatList();
    private FloatList projectionIdxList = new FloatList();
    private Ranking oldRank = null;
    private Ranking newRank = null;
    private int projectionsCounter = 0;
    private int calculatedDistances = 0;
    private float[] xArray;
    private ProgressBar bar;
    public String[] attrNames;
    private static int WINDOW_SIZE = 20;

    /*
     * WARNING - void declaration
     */
    public final boolean init$660d8861(FArray inputArray, MCFSParams mcfsParams, String chartTitle) {
        void var3_4;
        void var2_2;
        GlobalStats globalStats;
        this.myMCFSParams = mcfsParams;
        this.calculatedDistances = 0;
        this.projectionsCounter = 0;
        this.attrNames = inputArray.getColNames(true);
        this.attrRI = GlobalStats.initImportances(this.myMCFSParams, inputArray);
        if (mcfsParams.buildID) {
            this.attrID = new AttributesID(this.attrNames, true, false);
        }
        this.confusionMatrix = inputArray.isTargetNominal() ? new ConfusionMatrix(inputArray.getColNames(true)[inputArray.getDecAttrIdx()], ((FArray)((Object)globalStats)).getDecValuesStr()) : null;
        this.initChartFrame((MCFSParams)var2_2, (String)var3_4);
        globalStats = this;
        this.myLinearRegression = new LinearRegression();
        globalStats.xArray = new float[WINDOW_SIZE];
        int n = 0;
        while (n < globalStats.xArray.length) {
            int n2 = n++;
            globalStats.xArray[n2] = n2;
        }
        this.splitsStats = new StatsList();
        return true;
    }

    public final void initTextProgressBar() {
        this.bar = new ProgressBar(this.myMCFSParams.projectionsValue, true, true, true);
    }

    public final void finalizeTextProgressBar() {
        if (this.bar != null) {
            this.bar.finish();
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean initChartFrame(MCFSParams mcfsParams, String chartTitle) {
        if (mcfsParams.progressShow) {
            if (this.distanceChart != null) {
                this.distanceChart.dispose();
                this.distanceChart = null;
            }
            try {
                void var2_2;
                this.distanceChart = new ChartFrame("dmLab", (String)var2_2);
            }
            catch (HeadlessException headlessException) {
                System.err.println("Warning! Progress chart frame cannot be displayed.");
            }
        }
        return true;
    }

    public final boolean closeChartFrame() {
        if (this.distanceChart != null) {
            this.distanceChart.setVisible(false);
            this.distanceChart.dispose();
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public static AttributesRI[] initImportances(MCFSParams mcfsParams, FArray inputArray) {
        void var3_3;
        String[] decValues = inputArray.getDecValuesStr();
        AttributesRI[] importances = new AttributesRI[1];
        if (mcfsParams.model == Classifier.ADX) {
            importances = new AttributesRI[1 + decValues.length];
        }
        int i = 0;
        while (i < importances.length) {
            importances[i] = new AttributesRI(inputArray);
            importances[i].addMeasure(new ProjectionMeasure(null));
            importances[i].addMeasure(new ClassifiersMeasure(null));
            importances[i].addMeasure(new NodesMeasure(null));
            if (mcfsParams.model == Classifier.J48 || mcfsParams.model == Classifier.M5) {
                importances[i].addMeasure(new J48RIMeasure(mcfsParams));
            } else if (mcfsParams.model == Classifier.SLIQ) {
                importances[i].addMeasure(new SliqRIMeasure(mcfsParams));
            } else if (mcfsParams.model == Classifier.ADX) {
                importances[i].addMeasure(new ADXRIMeasure(mcfsParams));
            }
            importances[i].addMeasure(new RINormMeasure(mcfsParams));
            importances[i].mainMeasureIdx = importances[i].getMeasureIndex(ImportanceMeasure.MEASURE_RI);
            importances[i].label = i == 0 ? "" : decValues[i - 1];
            importances[i].initImportances();
            ++i;
        }
        return var3_3;
    }

    public final void finalizeImportances() {
        int j = 0;
        while (j < this.attrRI.length) {
            if (this.attrRI[j] != null) {
                this.attrRI[j].calcNormalizedMeasures(this.myMCFSParams.splits, true);
            }
            ++j;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized boolean updateSplitsStats(StatsList localSplitsStats) {
        void var1_1;
        return this.splitsStats.add((StatsList)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized boolean update$49ff765b(ConfusionMatrix localMatrix, AttributesRI[] localImportances, AttributesID localAttrID) {
        if (this.projectionsCounter >= this.myMCFSParams.projectionsValue) {
            return false;
        }
        this.projectionsCounter = (this.calculatedDistances + 1) * this.myMCFSParams.progressInterval;
        if (this.confusionMatrix != null) {
            this.confusionMatrix.add(localMatrix);
        }
        if (this.attrID != null) {
            this.attrID.addAttributesID(localAttrID);
        }
        int j = 0;
        while (j < this.attrRI.length) {
            if (this.attrRI[j] != null) {
                this.attrRI[j].sumImportances(localImportances[j]);
                this.attrRI[j].calcNormalizedMeasures(this.myMCFSParams.splits, false);
            }
            ++j;
        }
        this.newRank = this.attrRI[0].getTopRankingSize(this.attrRI[0].mainMeasureIdx, this.myMCFSParams.progressTopMinSize);
        if (this.oldRank != null) {
            float yArray22;
            float distance = this.newRank.compare(this.oldRank);
            float commonPart = this.newRank.commonPart(this.oldRank);
            float mAvg = 0.0f;
            float beta1 = 0.0f;
            if (this.distanceList.size() >= WINDOW_SIZE) {
                Object yArray22 = this.distanceList.toArray(this.distanceList.size() - WINDOW_SIZE, this.distanceList.size());
                mAvg = (float)MathUtils.mean(ArrayUtils.float2double((float[])yArray22));
                Object[] objectArray = yArray22;
                Object[] objectArray2 = this.xArray;
                yArray22 = this.myLinearRegression;
                objectArray2 = ArrayUtils.float2double(objectArray2);
                objectArray = ArrayUtils.float2double(objectArray);
                ((LinearRegression)yArray22).calc((double[])objectArray2, (double[])objectArray);
                yArray22 = (float)this.myLinearRegression.getBeta1();
            }
            if (this.calculatedDistances > 1) {
                void var3_7;
                void var2_5;
                void var1_3;
                this.projectionIdxList.add(this.projectionsCounter);
                this.distanceList.add((float)var1_3);
                this.commonPartList.add((float)var2_5);
                this.betaList.add(yArray22);
                this.mAvgList.add((float)var3_7);
                if (this.distanceChart != null) {
                    ArrayList<DataSeries> series = new ArrayList<DataSeries>();
                    series.add(new DataSeries("distance", this.projectionIdxList.toArray(), this.distanceList.toArray(), true));
                    series.add(new DataSeries("common part", this.projectionIdxList.toArray(), this.commonPartList.toArray(), false));
                    series.add(new DataSeries("beta1", this.projectionIdxList.toArray(), this.betaList.toArray(), false));
                    this.distanceChart.setAxisLabels("projections number", "distance value");
                    this.distanceChart.draw(series);
                }
            }
            if (this.bar != null) {
                this.bar.setVal(this.projectionsCounter);
            }
        }
        this.oldRank = this.newRank;
        ++this.calculatedDistances;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final DataFrame getDistances() {
        void var1_1;
        DataFrame distancesDF = new DataFrame(this.distanceList.size(), 5);
        distancesDF.setColNames(new String[]{"projection", "distance", "commonPart", "mAvg", "beta1"});
        distancesDF.setColTypes(new short[]{1, 1, 1, 1, 1});
        distancesDF.setColumn(0, this.projectionIdxList.toArray());
        distancesDF.setColumn(1, this.distanceList.toArray());
        distancesDF.setColumn(2, this.commonPartList.toArray());
        distancesDF.setColumn(3, this.mAvgList.toArray());
        distancesDF.setColumn(4, this.betaList.toArray());
        return var1_1;
    }

    public final ConfusionMatrix getConfusionMatrix() {
        return this.confusionMatrix;
    }

    public final AttributesRI[] getAttrImportances() {
        return this.attrRI;
    }

    public final AttributesID getAttrConnections() {
        return this.attrID;
    }

    public final StatsList getSplitsStats() {
        return this.splitsStats;
    }

    public final Cutoff getCutoff() {
        return this.cutoff;
    }

    /*
     * WARNING - void declaration
     */
    public final void setCutoff(Cutoff cutoff) {
        void var1_1;
        this.cutoff = var1_1;
    }
}

