% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{twedt_dist_measures}
\alias{twedt_dist_measures}
\title{Repeated measures and multivariate measures of perceived distance}
\format{
A data frame with 230 rows and 7 columns\tabular{lll}{
   \verb{[,1]} \tab \code{Subject} \tab Unique identifier for each participant \cr
   \verb{[,2]} \tab \verb{Physical Distance} \tab Physical distance from the participant to the target cone, in meters \cr
   \verb{[,3]} \tab \verb{Blindwalk Away} \tab Participants put on the blindfold after viewing the target. Next, participants took one step to the left and turned 180 degrees to face the opposite direction. Participants were instructed to walk forward until they had walked the original distance to the target \cr
   \verb{[,4]} \tab \verb{Blindwalk Toward} \tab Participants put on the blindfold after viewing the target.  Next, participants walked forward until they thought they had reached the target cone \cr
   \verb{[,5]} \tab \verb{Triangulated BW} \tab Participants put on the blindfold after viewing the target. Next, participants turned right 90 degrees and walked forward 5 meters. The experimenter told participants when to stop walking. Finally, participants turned to face toward the target and walked forward two steps \cr
   \verb{[,6]} \tab \code{Verbal} \tab Participants stated the distance between the target cone and themselves, in feet and inches \cr
   \verb{[,7]} \tab \verb{Visual Matching} \tab An experimenter stood next to the target cone and walked away from the cone in a straight line that was perpendicular to the extent  between the target and the participant. Participants instructed the experimenter to stop walking when they thought that the distance between the target and the experimenter was equal to  the target distance \cr
}
}
\source{
Twedt, E. Bakdash, J.Z., and Proffitt, D.R. (2022).
Repeated and multivariate measures of perceived distance (Dataset)
\doi{https://doi.org/10.5281/zenodo.6967162}
}
\usage{
twedt_dist_measures
}
\description{
A dataset of repeated measures of distance perception
at physical distances of 7, 8, 9, 10, and 11 meters. The data are also
multivariate, with five dependent measures of distance perception. This is a
5 (physical distance) x 5 (dependent measure) within-participants design
with a sample size of 46.
Note data is missing for 15 trials due to participant and experimenter errors.
}
