% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mdcev.sim.R, R/mdcev.sim.methods.R
\name{mdcev.sim}
\alias{mdcev.sim}
\alias{print.mdcev.sim}
\alias{summary.mdcev.sim}
\alias{print.summary.mdcev.sim}
\title{mdcev.sim}
\usage{
mdcev.sim(
  df_indiv,
  df_common,
  sim_options,
  sim_type = c("welfare", "demand"),
  nerrs = 30,
  cond_error = 1,
  draw_mlhs = 1,
  algo_gen = NULL,
  tol = 1e-20,
  max_loop = 999,
  suppressTime = FALSE,
  ...
)

\method{print}{mdcev.sim}(
  x,
  digits = max(3, getOption("digits") - 3),
  width = getOption("width"),
  ...
)

\method{summary}{mdcev.sim}(object, ci = 0.95, ...)

\method{print}{summary.mdcev.sim}(
  x,
  digits = max(3, getOption("digits") - 2),
  width = getOption("width"),
  ...
)
}
\arguments{
\item{df_indiv}{Prepared individual level data from PrepareSimulationData}

\item{df_common}{Prepared common data from PrepareSimulationData}

\item{sim_options}{Prepared simulation options from PrepareSimulationData}

\item{sim_type}{Either "welfare" or "demand"}

\item{nerrs}{Number of error draws for welfare analysis}

\item{cond_error}{Choose whether to draw errors conditional on actual demand or not.
Conditional error draws (=1) or unconditional error draws.}

\item{draw_mlhs}{Generate draws using Modified Latin Hypercube Sampling
algorithm (=1) or uniform (=0)}

\item{algo_gen}{Type of algorhitm for simulation. algo_gen = 0 for Hybrid Approach
(i.e. constant alphas, only model 3/4) alog_gen = 1 for General approach
(i.e. heterogeneous alpha's, all models)}

\item{tol}{Tolerance level for simulations if using general approach}

\item{max_loop}{maximum number of loops for simulations if using general approach}

\item{suppressTime}{Supress simulation time calculation}

\item{...}{Additional parameters to pass to mdcev.sim}

\item{x, object}{an object of class `mdcev.sim`}

\item{digits}{the number of digits,}

\item{width}{the width of the printing,}

\item{ci}{choose confidence interval for simulations. Default is 95 percent.}
}
\value{
a object of class mdcev.sim which contains a list for each
individual holding either 1) nsims x npols matrix of welfare changes if
welfare is being simulated or 2) nsims number of lists of npols x # alternatives
matrix of Marshallian demands is demand is being simulated.
}
\description{
Simulate welfare or demand for MDCEV model
}
\examples{
\donttest{
data(data_rec, package = "rmdcev")

data_rec <- mdcev.data(data_rec, subset = id < 500,
                alt.var = "alt", choice = "quant")

mdcev_est <- mdcev( ~ 1, data = data_rec,
               model = "hybrid0", algorithm = "MLE")

policies <- CreateBlankPolicies(npols = 2,
nalts = mdcev_est[["stan_data"]][["J"]],
dat_psi = mdcev_est[["stan_data"]][["dat_psi"]],
price_change_only = TRUE)

df_sim <- PrepareSimulationData(mdcev_est, policies)

wtp <- mdcev.sim(df_sim$df_indiv,
df_common = df_sim$df_common,
sim_options = df_sim$sim_options,
cond_err = 1, nerrs = 5, sim_type = "welfare")
}
}
\seealso{
[mdcev()] for the estimation of mdcev models.
}
