% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GenerateMDCEVData.R
\name{GenerateMDCEVData}
\alias{GenerateMDCEVData}
\title{GenerateMDCEVData}
\usage{
GenerateMDCEVData(
  model,
  nobs = 1000,
  nalts = 10,
  income = stats::runif(nobs, 1e+05, 150000),
  price = matrix(stats::runif(nobs * nalts, 100, 500), nobs, nalts),
  alpha_parms = 0.5,
  scale_parms = 1,
  gamma_parms = stats::runif(nalts, 1, 10),
  psi_i_parms = c(-1.5, 2, -1),
  psi_j_parms = c(-5, 0.5, 2),
  phi_parms = c(-5, 0.5, 2),
  dat_psi_i = matrix(2 * stats::runif(nobs * length(psi_i_parms)), nobs,
    length(psi_i_parms)),
  dat_psi_j = cbind(matrix(stats::runif(nalts * (length(psi_j_parms)), 0, 1), nrow =
    nalts)),
  dat_phi = cbind(matrix(stats::runif(nalts * (length(phi_parms)), 0, 1), nrow =
    nalts)),
  nerrs = 1,
  tol = 1e-20,
  max_loop = 999
)
}
\arguments{
\item{model}{A string indicating which model specification is estimated.
The options are "alpha", "gamma", "hybrid" and "hybrid0" for the MDCEV model and "kt_ee" for the environmental
economics Kuhn-Tucker specification.}

\item{nobs}{Number of individuals}

\item{nalts}{Number of non-numeraire alts}

\item{income}{Vector of individual income}

\item{price}{Matrix of prices for non-numeraire alternatives.}

\item{alpha_parms}{Parameter value for alpha term}

\item{scale_parms}{Parameter value for scale term}

\item{gamma_parms}{Parameter value for gamma terms}

\item{psi_i_parms}{Parameter value for psi terms that vary by individual}

\item{psi_j_parms}{Parameter value for psi terms that vary by alt (all models except kt_ee)}

\item{phi_parms}{Parameter value for phi terms that vary by alt (kt_ee model only)}

\item{dat_psi_i}{(nobs X # psi_i_parms) matrix with individual-specific characteristics}

\item{dat_psi_j}{(nalts X # psi_j_parms) matrix with alternative-specific variables (all models except kt_ee)}

\item{dat_phi}{(nalts X # phi_parms) matrix with alternative-specific variables (kt_ee model only)}

\item{nerrs}{Number of error draws for demand simulation}

\item{tol}{Tolerance level for simulations if using general approach}

\item{max_loop}{maximum number of loops for simulations if using general approach}
}
\value{
A `mdcev.data` object, which is a `data.frame` in long
    format. Also includes parms_true with parameter values
}
\description{
Simulate data for KT models
}
\examples{
\donttest{
data <- GenerateMDCEVData(model = "gamma")
}
}
