% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_method.R, R/metalog.R
\docType{package}
\name{rmetalog}
\alias{rmetalog}
\alias{rmetalog-package}
\title{Create random samples from an metalog distribution object}
\usage{
rmetalog(m, n = 1, term = 3)
}
\arguments{
\item{m}{metalog object created from \code{metalog()}}

\item{n}{number of observations (default is 1)}

\item{term}{which metalog distribution to sample from}
}
\value{
A numeric vector of n random samples from a selected distribution
}
\description{
The \code{rmetalog} package implements the metalog distribution in \code{R}
}
\examples{
# Load example data
data("fishSize")

# Create a bounded metalog object
myMetalog <- metalog(fishSize$FishSize,
                     bounds=c(0, 60),
                     boundedness = 'b',
                     term_limit = 9,
                     term_lower_bound = 9)

s <- rmetalog(myMetalog, n=1000, term = 9)
hist(s)
}
