# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

nearest_neighbors <- function(data, k) {
    .Call('_rmi_nearest_neighbors', PACKAGE = 'rmi', data, k)
}

#' kNN Mutual Information Estimators
#'
#' Computes mutual information based on the distribution of nearest neighborhood distances. Method available are KSG1 and KSG2 as described by Kraskov, et. al (2004) and the Local Non-Uniformity Corrected (LNC) KSG as described by Gao, et. al (2015). The LNC method is based on KSG2  but with PCA volume corrections to adjust for observed non-uniformity of the local neighborhood of each point in the sample.
#'
#' @param  data Matrix of sample observations, each row is an observation.
#' @param  splits A vector that describes which sets of columns in \code{data} to compute the mutual information between. For example, to compute mutual information between two variables use \code{splits = c(1,1)}. To compute \emph{redundancy} among multiple random variables use \code{splits = rep(1,ncol(data))}. To compute the mutual information between two random vector list the dimensions of each vector.
#' @param  options A list that specifies the estimator and its necessary parameters (see details).
#' @section Details: Current available methods are LNC, KSG1 and KSG2.
#'
#' For KSG1 use: \code{options = list(method = "KSG1", k = 5)}
#'
#' For KSG2 use: \code{options = list(method = "KSG2", k = 5)}
#'
#' For LNC use: \code{options = list(method = "LNC", k = 10, alpha = 0.65)}, order needed \code{k > ncol(data)}.
#'
#' @section Author:
#' Isaac Michaud, North Carolina State University, \email{ijmichau@ncsu.edu}
#' @section References:
#' Gao, S., Ver Steeg G., & Galstyan A. (2015). Efficient estimation of mutual information for strongly dependent variables. Artificial Intelligence and Statistics: 277-286.
#'
#' Kraskov, A., Stogbauer, H., & Grassberger, P. (2004). Estimating mutual information. Physical review E 69(6): 066138.
#' @examples
#' set.seed(123)
#' x <- rnorm(1000)
#' y <- x + rnorm(1000)
#' knn_mi(cbind(x,y),c(1,1),options = list(method = "KSG2", k = 6))
#'
#' set.seed(123)
#' x <- rnorm(1000)
#' y <- 100*x + rnorm(1000)
#' knn_mi(cbind(x,y),c(1,1),options = list(method = "LNC", alpha = 0.65, k = 10))
#' #approximate analytic value of mutual information
#' -0.5*log(1-cor(x,y)^2)
#'
#' z <- rnorm(1000)
#' #redundancy I(x;y;z) is approximately the same as I(x;y)
#' knn_mi(cbind(x,y,z),c(1,1,1),options = list(method = "LNC", alpha = c(0.5,0,0,0), k = 10))
#' #mutual information I((x,y);z) is approximately 0
#' knn_mi(cbind(x,y,z),c(2,1),options = list(method = "LNC", alpha = c(0.5,0.65,0), k = 10))
#'
#' @export
#' @useDynLib rmi
#'
knn_mi <- function(data, splits, options) {
    .Call('_rmi_knn_mi', PACKAGE = 'rmi', data, splits, options)
}

parse_split_vector <- function(splits, d, start_d, end_d) {
    invisible(.Call('_rmi_parse_split_vector', PACKAGE = 'rmi', splits, d, start_d, end_d))
}

