% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/local_nearest_neighbor.R
\name{lnn_mi}
\alias{lnn_mi}
\title{Local Nearest Neighbor (LNN) MI Estimator}
\usage{
lnn_mi(data, splits, k = 5, tr = 30)
}
\arguments{
\item{data}{Matrix of sample observations, each row is an observation.}

\item{splits}{A vector that describes which sets of columns in \code{data} to compute the mutual information between. For example, to compute mutual information between two variables use \code{splits = c(1,1)}. To compute \emph{redundancy} among multiple random variables use \code{splits = rep(1,ncol(data))}. To compute the mutual information between two random vector list the dimensions of each vector.}

\item{k}{Order of the local kNN bandwidth selection.}

\item{tr}{Order of truncation (number of neighbors to include in the local density estimation).}
}
\description{
Local Nearest Neighbor (LNN) mutual information estimator by Gao et al. 2017. This estimator uses the LNN entropy (\code{lnn_entropy}) estimator into the mutual information identity.
}
\section{References}{


Gao, W., Oh, S., & Viswanath, P. (2017). Density functional estimators with k-nearest neighbor bandwidths. IEEE International Symposium on Information Theory - Proceedings, 1, 1351–1355.
}

\examples{
set.seed(123)
x <- rnorm(1000)
y <- x + rnorm(1000)
lnn_mi(cbind(x,y),c(1,1))

}
