/*
 * Decompiled with CFR 0.152.
 */
package com.chenlb.mmseg4j;

import com.chenlb.mmseg4j.Word;

public class Chunk {
    Word[] words = new Word[3];
    int count = -1;
    private int len = -1;
    private double avgLen = -1.0;
    private double variance = -1.0;
    private int sumDegree = -1;

    public int getLen() {
        if (this.len < 0) {
            this.len = 0;
            this.count = 0;
            for (Word word : this.words) {
                if (word == null) continue;
                this.len += word.getLength();
                ++this.count;
            }
        }
        return this.len;
    }

    public int getCount() {
        if (this.count < 0) {
            this.count = 0;
            for (Word word : this.words) {
                if (word == null) continue;
                ++this.count;
            }
        }
        return this.count;
    }

    public double getAvgLen() {
        if (this.avgLen < 0.0) {
            this.avgLen = (double)this.getLen() / (double)this.getCount();
        }
        return this.avgLen;
    }

    public double getVariance() {
        if (this.variance < 0.0) {
            double d = 0.0;
            for (Word word : this.words) {
                if (word == null) continue;
                d += Math.pow((double)word.getLength() - this.getAvgLen(), 2.0);
            }
            this.variance = d / (double)this.getCount();
        }
        return this.variance;
    }

    public int getSumDegree() {
        if (this.sumDegree < 0) {
            int n = 0;
            for (Word word : this.words) {
                if (word == null || word.getDegree() <= -1) continue;
                n += word.getDegree();
            }
            this.sumDegree = n;
        }
        return this.sumDegree;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Word word : this.words) {
            if (word == null) continue;
            stringBuilder.append(word.getString()).append('_');
        }
        return stringBuilder.toString();
    }

    public String toFactorString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        stringBuilder.append("len=").append(this.getLen()).append(", ");
        stringBuilder.append("avgLen=").append(this.getAvgLen()).append(", ");
        stringBuilder.append("variance=").append(this.getVariance()).append(", ");
        stringBuilder.append("sum100log=").append(this.getSumDegree()).append("]");
        return stringBuilder.toString();
    }

    public Word[] getWords() {
        return this.words;
    }

    public void setWords(Word[] wordArray) {
        this.words = wordArray;
        this.count = wordArray.length;
    }
}

