% Generated by roxygen2 (4.0.2): do not edit by hand
\name{mongo.bson.from.df}
\alias{mongo.bson.from.df}
\title{Convert a data.frame to a mongo.bson object}
\usage{
mongo.bson.from.df(df)
}
\arguments{
\item{df}{(data.frame) The data.frame to convert.

This \emph{must} be a data.frame, \emph{not} a vector of atomic types; otherwise,
an error is thrown; use \code{as.data.frame()} as necessary.}
}
\value{
(\link{mongo.bson}) A mongo.bson object serialized from \code{data.frame}.
}
\description{
Convert a data.frame to a \link{mongo.bson} object.
}
\details{
This function permits the simple and convenient creation of a mongo.bson
object.  This bypasses the creation of a \link{mongo.bson.buffer}, appending
fields one by one, and then turning the buffer into a mongo.bson object with
\code{\link{mongo.bson.from.buffer}()}.
}
\examples{
df <- data.frame(name=c("John", "Peter"), age=c(32,18))
b <- mongo.bson.from.df(df)
}
\seealso{
\code{\link{mongo.bson.to.list}},\cr \link{mongo.bson},\cr
\code{\link{mongo.bson.destroy}}.
}

