% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/improved.UME_function.R
\name{improved_ume}
\alias{improved_ume}
\title{A function to detect the frail comparisons in multi-arm trials}
\usage{
improved_ume(t, N, ns, na)
}
\arguments{
\item{t}{A data-frame of the one-trial-per-row format containing the
intervention identifier in each arm of every trial (see 'Details' below,
and 'Format' in \code{\link{run_model}}).}

\item{N}{A data-frame of the one-trial-per-row format containing the number
of participants randomised on the assigned intervention in each arm of
every trial (see 'Details' below, and 'Format' in \code{\link{run_model}}).}

\item{ns}{A scale parameter on the number trials.}

\item{na}{A vector of length equal to \code{ns} with the number of arms in
each trial.}
}
\value{
The output of \code{improved_ume} is a list of elements that are used
  by \code{\link{run_ume}}:
  \tabular{ll}{
   \code{nbase_multi} \tab A scalar parameter on the number of frail
   comparisons.\cr
   \tab \cr
   \code{t1_bn} \tab A vector with numeric values referring to the first arm
   of each frail comparison.\cr
   \tab \cr
   \code{t2_bn} \tab A vector with numeric values referring to the second arm
   of each frail comparison.\cr
   \tab \cr
   \code{base} \tab A vector with numeric values referring to the baseline
   intervention of the multi-arm trials that contain the frail
   comparisons.\cr
   \tab \cr
   \code{obs_comp} \tab A data-frame that indicates how many two-arms and
   multi-arm trials have included each pairwise comparison observed in the
   network.\cr
  }
}
\description{
Detects the frail comparisons in multi-arm trials, that is,
  comparisons between non-baseline interventions not investigated in any
  two-arm trial in the network (Spineli, 2021). The 'original' model of
  Dias et al., (2013) omits the frail comparisons from the estimation process
  of the unrelated mean effects model. Consequently, their posterior
  distribution coincides with the prior distribution yielding implausible
  posterior standard deviations.
}
\details{
\code{improved_ume} is integrated in \code{\link{run_ume}} and
  calls the output of \code{\link{data_preparation}} after sorting the
  rows so that multi-arm trials appear at the bottom of the dataset.
  When there are no multi-arm trials or no frail comparisons in the network,
  \code{improved_ume} returns only the element \code{obs_comp}
  (see, 'Value').
}
\references{
Spineli LM. A novel framework to evaluate the consistency assumption globally
in a network of interventions. \emph{submitted} 2021.

Dias S, Welton NJ, Sutton AJ, Caldwell DM, Lu G, Ades AE. Evidence synthesis
for decision making 4: inconsistency in networks of evidence based on
randomized controlled trials.
\emph{Med Decis Making} 2013;\bold{33}(5):641--56.
\doi{10.1177/0272989X12455847}
}
\seealso{
\code{\link{data_preparation}}, \code{\link{run_model}},
  \code{\link{run_ume}}
}
\author{
{Loukia M. Spineli}
}
