% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/league.table.absolute_function.R
\name{league_table_absolute}
\alias{league_table_absolute}
\title{League table for relative and absolute effects}
\usage{
league_table_absolute(full, drug_names, show = NULL)
}
\arguments{
\item{full}{An object of S3 class \code{\link{run_model}}.
See 'Value' in \code{\link{run_model}}.}

\item{drug_names}{A vector of labels with the name of the interventions in
the order they appear in the argument \code{data} of
\code{\link{run_model}}.}

\item{show}{A vector of at least three character strings that refer to the
names of the interventions \emph{exactly} as defined in \code{drug_names}.
Then, the league table will be created for these interventions only.
If \code{show} is not defined, the league table will present all
interventions as defined in \code{drug_names}.}
}
\value{
A league table showing the posterior estimate and 95\% credible
  interval of the odds ratio (upper off-diagonals), risk difference per 1000
  participants (lower off-diagonals), and absolute risks per 1000
  participants (main diagonal).
}
\description{
Provides a league table of the estimated odds ratio, and risk difference
  per 1000 participants for all possible comparisons of interventions in the
  network. The main diagonal of the table presents the absolute risk for each
  intervention in the network. \code{league_table_absolute} can be used for a
  random-effects or fixed-effect network meta-analysis.
  It is applied for one binary outcome only.
}
\details{
The user must define the argument \code{measure = "RD"} in
  \code{\link{run_model}}; otherwise, the function will be stopped and an
  error message will be printed in the R console.

  The rows and columns of the league table display the names of the
  interventions  sorted by decreasing order from the best to the worst
  based on their SUCRA value (Salanti et al., 2011) for the odds ratio. The
  upper off-diagonals contain the posterior median and 95\% credible interval
  of the odds ratio, the lower off-diagonals contain the posterior median and
  95\% credible interval of the risk difference (per 1000 participants), and
  the main diagonal comprises the posterior median and 95\% credible interval
  of the absolute risks (per 1000 participants) of the  corresponding
  interventions. The reference intervention of the network (which the
  baseline risk has been selected for) is indicated in the main diagonal with
  a homonymous label.

  Comparisons between interventions should be read from left to right.
  Results that indicate strong evidence in favor of the row-defining
  intervention (i.e. the respective 95\% credible interval does not include
  the null value) are indicated in bold.

  To obtain unique absolute risks for each intervention, the network
  meta-analysis model has been extended to incorporate the transitive risks
  framework, namely, an intervention has the same absolute risk regardless of
  the comparator intervention(s) in a trial (Spineli et al., 2017).
  The absolute risks are a function of the odds ratio (the \strong{base-case}
  effect measure for a binary outcome) and the selected baseline risk for the
  reference intervention (Appendix in Dias et al., 2013). See 'Arguments' in
  \code{\link{run_model}}. We advocate using the odds ratio as an effect
  measure for its desired mathematical properties. Then, the risk difference
  can be obtained as a function of the absolute risks of the corresponding
  interventions in the comparison of interest.

  \code{league_table_absolute} can be used only for a network of
  interventions. In the case of two interventions, the execution of the
  function will be stopped and an error message will be printed in the R
  console.
}
\references{
Salanti G, Ades AE, Ioannidis JP. Graphical methods and numerical summaries
for presenting results from multiple-treatment meta-analysis: an overview and
tutorial. \emph{J Clin Epidemiol} 2011;\bold{64}(2):163--71.
doi: 10.1016/j.jclinepi.2010.03.016

Spineli LM, Brignardello-Petersen R, Heen AF, Achille F, Brandt L,
Guyatt GH, et al. Obtaining absolute effect estimates to facilitate shared
decision making in the context of multiple-treatment comparisons.
Abstracts of the Global Evidence Summit, Cape Town, South Africa.
\emph{Cochrane Database of Systematic Reviews} 2017;\bold{9}(Suppl 1):1891.
}
\seealso{
\code{\link{run_model}}
}
\author{
{Loukia M. Spineli}
}
