% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ncdc_datatypes.r
\name{ncdc_datatypes}
\alias{ncdc_datatypes}
\title{Get possible data types for a particular dataset}
\usage{
ncdc_datatypes(datasetid = NULL, datatypeid = NULL, datacategoryid = NULL,
  stationid = NULL, locationid = NULL, startdate = NULL, enddate = NULL,
  sortfield = NULL, sortorder = NULL, limit = 25, offset = NULL,
  token = NULL, dataset = NULL, page = NULL, filter = NULL, ...)
}
\arguments{
\item{datasetid}{(optional) Accepts a valid dataset id or a vector or list of them. Data 
returned will be from the dataset specified.}

\item{datatypeid}{Accepts a valid data type id or a vector or list of data type ids.
(optional)}

\item{datacategoryid}{Optional. Accepts a valid data category id or a vector or list
of data category ids (although it is rare to have a data type with more than 
one data category)}

\item{stationid}{Accepts a valid station id or a vector or list of station ids}

\item{locationid}{Accepts a valid location id or a vector or list of location ids
(optional)}

\item{startdate}{(optional) Accepts valid ISO formated date (yyyy-mm-dd) or date time
(YYYY-MM-DDThh:mm:ss). Data returned will have data after the specified date. The
date range must be less than 1 year.}

\item{enddate}{(optional) Accepts valid ISO formated date (yyyy-mm-dd) or date time
(YYYY-MM-DDThh:mm:ss). Data returned will have data before the specified date. The
date range must be less than 1 year.}

\item{sortfield}{The field to sort results by. Supports id, name, mindate, maxdate, and
datacoverage fields (optional)}

\item{sortorder}{Which order to sort by, asc or desc. Defaults to asc (optional)}

\item{limit}{Defaults to 25, limits the number of results in the response. Maximum is
1000 (optional)}

\item{offset}{Defaults to 0, used to offset the resultlist (optional)}

\item{token}{This must be a valid token token supplied to you by NCDC's Climate
Data Online access token generator. (required) Get an API key (=token) at
http://www.ncdc.noaa.gov/cdo-web/token. You can pass your token in as
an argument or store it in your .Rprofile file with an entry like
\itemize{
  \item options("noaakey" = "your-noaa-token")
}}

\item{dataset}{THIS IS A DEPRECATED ARGUMENT. See datasetid.}

\item{page}{THIS IS A DEPRECATED ARGUMENT. There is no equivalent argument in v2
of the NOAA API.}

\item{filter}{THIS IS A DEPRECATED ARGUMENT. There is no equivalent argument in v2
of the NOAA API.}

\item{...}{Curl options passed on to \code{\link[httr]{GET}} (optional)}
}
\value{
A \code{data.frame} for all datasets, or a list of length two, each with
   a data.frame.
}
\description{
From the NOAA API docs: Describes the type of data, acts as a label. If it's 64
degrees out right now, then the data type is Air Temperature and the data is 64.
}
\examples{
\dontrun{
# Fetch available data types
ncdc_datatypes()

# Fetch more information about the ACMH data type id, or the ACSC
ncdc_datatypes(datatypeid="ACMH")
ncdc_datatypes(datatypeid="ACSC")

# datasetid, one or many
ncdc_datatypes(datasetid="ANNUAL")
ncdc_datatypes(datasetid=c("ANNUAL", "PRECIP_HLY"))

# Fetch data types with the air temperature data category
ncdc_datatypes(datacategoryid="TEMP", limit=56)
ncdc_datatypes(datacategoryid=c("TEMP", "AUPRCP"))

# Fetch data types that support a given set of stations
ncdc_datatypes(stationid='COOP:310090')
ncdc_datatypes(stationid=c('COOP:310090','COOP:310184','COOP:310212'))

# Fetch data types that support a given set of loncationids
ncdc_datatypes(locationid='CITY:AG000001')
ncdc_datatypes(locationid=c('CITY:AG000001','CITY:AG000004'))
}
}

