# from https://www1.ncdc.noaa.gov/pub/data/cdo/documentation/GHCND_documentation.pdf and
# https://www1.ncdc.noaa.gov/pub/data/ghcn/daily/readme.txt
ncdc_units_ghcnd <- list(
  PRCP = list(name = "precipitation", units = "mm_tenths", description = "Precipitation"),
  SNOW = list(name = "snow_fall", units = "mm", description = "Snowfall"), 
  SNWD = list(name = "snow_depth", units = "mm", description = "Snow depth"),
  TMAX = list(name = "temperature_max", units = "celcius_tenths", description = "Maximum temperature (tenths of degrees C)"),
  TMIN = list(name = "temperature_min", units = "celcius_tenths", description = "Minimum temperature (tenths of degrees C)"),
  ACMC = list(name = "ACMC", units = "percent", description = "Average cloudiness midnight to midnight from 30-second ceilometer data (percent)"),
  ACMH = list(name = "ACMH", units = "percent", description = "Average cloudiness midnight to midnight from manual observations (percent)"),
  ACSC = list(name = "ACSC", units = "percent", description = "Average cloudiness sunrise to sunset from 30-second ceilometer data (percent)"),
  ACSH = list(name = "ACSH", units = "percent", description = "Average cloudiness sunrise to sunset from manual observations (percent)"),
  AWDR = list(name = "AWDR", units = "degrees", description = "Average daily wind direction (degrees)"),
  AWND = list(name = "AWND", units = "meters_per_sec_tenths", description = "Average daily wind speed (tenths of meters per second)"),
  DAEV = list(name = "DAEV", units = "number_of_days", description = "Number of days included in the multiday evaporation total (MDEV)"),
  DAPR = list(name = "DAPR", units = "number_of_days", description = "Number of days included in the multiday precipiation total (MDPR)"),
  DASF = list(name = "DASF", units = "number_of_days", description = "Number of days included in the multiday snowfall total (MDSF)"),
  DATN = list(name = "DATN", units = "number_of_days", description = "Number of days included in the multiday minimum temperature (MDTN)"),
  DATX = list(name = "DATX", units = "number_of_days", description = "Number of days included in the multiday maximum temperature (MDTX)"),
  DAWM = list(name = "DAWM", units = "number_of_days", description = "Number of days included in the multiday wind movement (MDWM)"),
  DWPR = list(name = "DWPR", units = "number_of_days", description = "Number of days with non-zero precipitation included in multiday precipitation total (MDPR)"),
  EVAP = list(name = "EVAP", units = "mm_tenths", description = "Evaporation of water from evaporation pan (tenths of mm)"),
  FMTM = list(name = "FMTM", units = "time", description = "Time of fastest mile or fastest 1-minute wind (hours and minutes, i.e., HHMM)"),
  FRGB = list(name = "FRGB", units = "cm", description = "Base of frozen ground layer (cm)"),
  FRGT = list(name = "FRGT", units = "cm", description = "Top of frozen ground layer (cm)"),
  FRTH = list(name = "FRTH", units = "cm", description = "Thickness of frozen ground layer (cm)"),
  GAHT = list(name = "GAHT", units = "cm", description = "Difference between river and gauge height (cm)"),
  MDEV = list(name = "MDEV", units = "mm_tenths", description = "Multiday evaporation total (tenths of mm; use with DAEV)"),
  MDPR = list(name = "MDPR", units = "mm_tenths", description = "Multiday precipitation total (tenths of mm; use with DAPR and DWPR, if available)"),
  MDSF = list(name = "MDSF", units = "mm", description = "Multiday snowfall total"),
  MDTN = list(name = "MDTN", units = "celcius_tenths", description = "Multiday minimum temperature (tenths of degrees C; use with DATN)"),
  MDTX = list(name = "MDTX", units = "celcius_tenths", description = "Multiday maximum temperature (tenths of degress C; use with DATX)"),
  MDWM = list(name = "MDWM", units = "km", description = "Multiday wind movement (km)"),
  MNPN = list(name = "MNPN", units = "celcius_tenths", description = "Daily minimum temperature of water in an evaporation pan (tenths of degrees C)"),
  MXPN = list(name = "MXPN", units = "celcius_tenths", description = "Daily maximum temperature of water in an evaporation pan (tenths of degrees C)"),
  PGTM = list(name = "PGTM", units = "time", description = "Peak gust time (hours and minutes, i.e., HHMM)"),
  PSUN = list(name = "PSUN", units = "percent", description = "Daily percent of possible sunshine (percent)"),
  TAVG = list(name = "TAVG", units = "celcius_tenths", description = "Average temperature (tenths of degrees C) [Note that TAVG from source 'S' corresponds to an average for the period ending at 2400 UTC rather than local midnight]"),
  THIC = list(name = "THIC", units = "mm_tenths", description = "Thickness of ice on water (tenths of mm)"),
  TOBS = list(name = "TOBS", units = "celcius_tenths", description = "Temperature at the time of observation (tenths of degrees C)"),
  TSUN = list(name = "TSUN", units = "minutes", description = "Daily total sunshine (minutes)"),
  WDF1 = list(name = "WDF1", units = "degrees", description = "Direction of fastest 1-minute wind (degrees)"),
  WDF2 = list(name = "WDF2", units = "degrees", description = "Direction of fastest 2-minute wind (degrees)"),
  WDF5 = list(name = "WDF5", units = "degrees", description = "Direction of fastest 5-second wind (degrees)"),
  WDFG = list(name = "WDFG", units = "degrees", description = "Direction of peak wind gust (degrees)"),
  WDFI = list(name = "WDFI", units = "degrees", description = "Direction of highest instantaneous wind (degrees)"),
  WDFM = list(name = "WDFM", units = "degrees", description = "Fastest mile wind direction (degrees)"),
  WDMV = list(name = "WDMV", units = "km", description = "24-hour wind movement (km)"),
  WESD = list(name = "WESD", units = "mm_tenths", description = "Water equivalent of snow on the ground (tenths of mm)"),
  WESF = list(name = "WESF", units = "mm_tenths", description = "Water equivalent of snowfall (tenths of mm)"),
  WSF1 = list(name = "WSF1", units = "meters_per_sec_tenths", description = "Fastest 1-minute wind speed (tenths of meters per second)"),
  WSF2 = list(name = "WSF2", units = "meters_per_sec_tenths", description = "Fastest 2-minute wind speed (tenths of meters per second)"),
  WSF5 = list(name = "WSF5", units = "meters_per_sec_tenths", description = "Fastest 5-second wind speed (tenths of meters per second)"),
  WSFG = list(name = "WSFG", units = "meters_per_sec_tenths", description = "Peak gust wind speed (tenths of meters per second)"),
  WSFI = list(name = "WSFI", units = "meters_per_sec_tenths", description = "Highest instantaneous wind speed (tenths of meters per second)"),
  WSFM = list(name = "WSFM", units = "meters_per_sec_tenths", description = "Fastest mile wind speed (tenths of meters per second)"),
  'SN[0-9]{2}' = list(name = "SN*", units = "celcius_tenths", 
    description = "Minimum soil temperature (tenths of degrees C) where * corresponds to a code for ground cover and # corresponds to a code for soil depth. `values` data.frame: first number is ground cover, second is depth", 
    values = data.frame(
      type = c(rep('ground_cover', 9), rep('depth', 7)),
      code = c(0, 1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7),
      value = c(
        "unknown", "grass", "fallow", "bare ground", "brome grass", 
        "sod", "straw multch", "grass muck", "bare muck", 
        "5 cm", "10 cm", "20 cm", "50 cm", "100 cm", "150 cm", "180 cm"),
      stringsAsFactors = FALSE
    )
  ),
  'SX[0-9]{2}' = list(name = "SX*", units = "celcius_tenths", 
    description = "Maximum soil temperature (tenths of degrees C) where * corresponds to a code for ground cover and # corresponds to a code for soil depth.", 
    values = data.frame(
      type = c(rep('ground_cover', 9), rep('depth', 7)),
      code = c(0, 1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7),
      value = c(
        "unknown", "grass", "fallow", "bare ground", "brome grass", 
        "sod", "straw multch", "grass muck", "bare muck", 
        "5 cm", "10 cm", "20 cm", "50 cm", "100 cm", "150 cm", "180 cm"),
      stringsAsFactors = FALSE
    )
  ),
  'WT[0-9]{2}' = list(name = "WT*", units = "no units", 
    description = "Weather Type",
    values = data.frame(
      code = c('01', '02', '03', '04', '05', '06', '07', '08', '09', '10', '11', '12', '13', '14', '15', '16', '17', '18', '19', '21', '22'),
      value = c("Fog, ice fog, or freezing fog (may include heavy fog)",
        "Heavy fog or heaving freezing fog (not always distinquished from fog)",
        "Thunder",
        "Ice pellets, sleet, snow pellets, or small hail ",
        "Hail (may include small hail)",
        "Glaze or rime ",
        "Dust, volcanic ash, blowing dust, blowing sand, or blowing obstruction",
        "Smoke or haze ",
        "Blowing or drifting snow",
        "Tornado, waterspout, or funnel cloud ",
        "High or damaging winds",
        "Blowing spray",
        "Mist",
        "Drizzle",
        "Freezing drizzle ",
        "Rain (may include freezing rain, drizzle, and freezing drizzle) ",
        "Freezing rain ",
        "Snow, snow pellets, snow grains, or ice crystals",
        "Unknown source of precipitation ",
        "Ground fog ",
        "Ice fog or freezing fog"),
      stringsAsFactors = FALSE
    )
  ),
  'WV[0-9]{2}' = list(name = "WV*", units = "no units", 
    description = "Weather in the Vicinity",
    values = data.frame(
      code = c('01', '03', '07', '18', '20'),
      value = c(
        "Fog, ice fog, or freezing fog (may include heavy fog)", "Thunder", 
        "Ash, dust, sand, or other blowing obstruction", "Snow or ice crystals", 
        "Rain or snow shower"),
      stringsAsFactors = FALSE
    )
  )
)

