% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/fData.R
\name{times-.fData}
\alias{*.fData}
\alias{/.fData}
\alias{times-.fData}
\title{Operator \code{*} and \code{/} for \code{fData} objects}
\usage{
\method{*}{fData}(fD, a)

\method{/}{fData}(fD, a)
}
\arguments{
\item{fD}{the univariate functional dataset in form of \code{fData} object.}

\item{a}{either a single number or a 1D data structure (such as numeric
raw vector, matrix or array) specifying the factor(s) to use in the
multiplication/division of \code{fD} elements' values.
In the latter case, each factor is used with the corresponding element in
\code{fD}, hence a must have length \code{N}, number of observations in
\code{fD}.}
}
\value{
The function returns an \code{fData} object, whose function values
have undergone the product/division.
}
\description{
These methods provide operators \code{*} and \code{/} to perform products
or divisions between an \code{fData} object and either a number or a
compliant 1D data structure, like numeric vector, array or
matrix. The operation is computed by performing the element-wise product
or division between \code{fD}'s observations and the provided value(s).
}
\details{
If the second argument is a 1D data structure, it must have length \code{N}
equal to the number of observations in \code{fD}.
}
\examples{
N = 11
fD = fData( seq( 0, 1, length.out = 10 ),
            values = matrix( seq( 1, 10 ),
                             nrow = N, ncol = 10, byrow = TRUE ) )
fD * 2

fD * seq( 1, N )
N = 11
fD = fData( seq( 0, 1, length.out = 10 ),
            values = matrix( seq( 1, 10 ),
                             nrow = N, ncol = 10, byrow = TRUE ) )
fD / 2

fD / rep( 10, N )
}

