% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intArray.R
\name{intArray}
\alias{intArray}
\title{Interaction array}
\usage{
intArray(x)
}
\arguments{
\item{x}{an object of class \dQuote{intTab}}
}
\value{
The interaction array
}
\description{
Estimates the interaction array
}
\details{
Estimates the interaction array using an ilr transformation of the interaction table.
}
\examples{
data(precipitation) 
tab1prob <- prop.table(precipitation)
tab1 <- indTab(precipitation)
tabINT <- intTab(tab1prob, tab1)
intArray(tabINT)
}
\references{
Juan Jose Egozcuea, Vera Pawlowsky-Glahn, Matthias Templ, Karel Hron (2015)
Independence in Contingency Tables Using Simplicial Geometry. 
\emph{Communications in Statistics - Theory and Methods}, Vol. 44 (18), 3978--3996.
DOI:10.1080/03610926.2013.824980
}
\seealso{
\code{\link{intTab}}
}
\author{
Matthias Templ
}
