% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/daFisher.R
\name{daFisher}
\alias{daFisher}
\alias{print.daFisher}
\alias{predict.daFisher}
\alias{summary.daFisher}
\title{Discriminant analysis by Fisher Rule.}
\usage{
daFisher(x, grp, coda = TRUE, method = "classical",
  plotScore = FALSE, ...)

\method{print}{daFisher}(x, ...)

\method{predict}{daFisher}(object, ..., newdata)

\method{summary}{daFisher}(object, ...)
}
\arguments{
\item{x}{a matrix or data frame containing the explanatory variables
(training set)}

\item{grp}{grouping variable: a factor specifying the class for each
observation.}

\item{coda}{TRUE, when the underlying data are compositions.}

\item{method}{\dQuote{classical} or \dQuote{robust} estimation.}

\item{plotScore}{TRUE, if the scores should be plotted automatically.}

\item{...}{additional arguments for the print method passed through}

\item{object}{object of class \dQuote{daFisher}}

\item{newdata}{new data in the appropriate form (CoDa, etc)}
}
\value{
an object of class \dQuote{daFisher} including the following
elements 
\item{B }{Between variance of the groups} 
\item{W }{Within variance
of the groups} 
\item{loadings}{loadings} 
\item{scores}{fisher scores} 
\item{mc}{table indicating misclassifications} 
\item{mcrate}{misclassification rate}  
\item{coda}{coda}
\item{grp}{grouping}
\item{grppred}{predicted groups}
\item{xc}{xc}
\item{meanj}{meanj}
\item{cv}{cv}
\item{pj}{pj}
\item{meanov}{meanov}
\item{fdiscr}{fdiscr}
}
\description{
Discriminant analysis by Fishers rule using CoDa methods.
}
\details{
The Fisher rule leads only to linear boundaries. However, this method allows
for dimension reduction and thus for a better visualization of the
separation boundaries. For the Fisher discriminant rule (Fisher, 1938; Rao,
1948) the assumption of normal distribution of the groups is not explicitly
required, although the method looses its optimality in case of deviations
from normality.

The classical Fisher discriminant rule is invariant to ilr and clr
transformations. The robust rule is invariant to ilr transformations if
affine equivariant robust estimators of location and covariance are taken.

Robustification is done (method \dQuote{robust}) by estimating the
columnwise means and the covariance by the Minimum Covariance Estimator.
}
\examples{
## toy data (non-compositional)
require(MASS)
x1 <- mvrnorm(20,c(0,0,0),diag(3))
x2 <- mvrnorm(30,c(3,0,0),diag(3))
x3 <- mvrnorm(40,c(0,3,0),diag(3))
X <- rbind(x1,x2,x3)
grp=c(rep(1,20),rep(2,30),rep(3,40))

#par(mfrow=c(1,2))
d1 <- daFisher(X,grp=grp,method="classical",coda=FALSE)
d2 <- daFisher(X,grp=grp,method="robust",coda=FALSE)
d2
summary(d2)
predict(d2, newdata = X)

## example with olive data:
\dontrun{
data(olive, package = "RnavGraph")
# exclude zeros (alternatively impute them if 
# the detection limit is known using impRZilr())
ind <- which(olive == 0, arr.ind = TRUE)[,1]
olives <- olive[-ind, ]
x <- olives[, 4:10]
grp <- olives$Region # 3 groups
res <- daFisher(x,grp)
res
summary(res)
res <- daFisher(x, grp, plotScore = TRUE)
res <- daFisher(x, grp, method = "robust")
res
summary(res)
predict(res, newdata = x)
res <- daFisher(x,grp, plotScore = TRUE, method = "robust")

# 9 regions
grp <- olives$Area
res <- daFisher(x, grp, plotScore = TRUE)
res
summary(res)
predict(res, newdata = x)
}
}
\references{
Filzmoser, P. and Hron, K. and Templ, M. (2012) 
Discriminant analysis for compositional data and robust parameter estimation. 
\emph{Computational Statistics}, Vol. 27(4), pp. 585-604, 2012.

Fisher, R. A. (1938) The statistical utiliziation of multiple measurements.
\emph{Annals of Eugenics}, 8:376-386.

Rao, C.R. (1948) The utilization of multiple measurements in problems of
biological classification. \emph{Journal of the Royal Statistical Society},
Series B, 10:159-203.
}
\seealso{
\code{\link[rrcov]{Linda}}
}
\author{
Peter Filzmoser, Matthias Templ.
}
\keyword{multivariate}
