% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/robustness_bm.R
\name{auc_robustness_lbm}
\alias{auc_robustness_lbm}
\title{Fast computation of the LBM robustness statistic for uniform extinctions}
\usage{
auc_robustness_lbm(con, pi, rho, nr, nc)
}
\arguments{
\item{con}{A matrix, the connectivity parameter}

\item{pi}{A vector of length \code{nrow(con)}, the proportion of row blocks}

\item{rho}{A vector of length \code{ncol(con)}, the proportion of
column blocks}

\item{nr}{An integer, the number of row (primary) species}

\item{nc}{An integer, the number of column (secondary) species}
}
\value{
The AUC of the LBM Robustness function for uniform primary
extinctions sequences.
}
\description{
This function provides much faster computation than \code{robustness_lbm} for
the case where \code{ext_seq = "uniform"}, when just the AUC statistic is
needed and the robustness function is not needed. This is particularly
useful if \code{nr} gets large.
}
\examples{
con <- matrix(c(.5,.3,.3,.1), 2, 2)
pi  <- c(.25,.75)
rho <- c(1/3, 2/3)
nr <- 50
nc <- 30
auc_robustness_lbm(con, pi, rho, nr, nc)
}
