% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_bm.R
\name{simulate_lbm}
\alias{simulate_lbm}
\title{Simulate a bipartite interaction network using block model}
\usage{
simulate_lbm(con, pi, rho, nr, nc, method = "gnp")
}
\arguments{
\item{con}{A matrix, the connectivity between blocks. If
\code{method = "gnp"} then each entry is the probability of interactions
given 2 blocks. If \code{method = "gnm"} then each entry is the number of
interactions between 2 blocks.}

\item{pi}{A vector of the same length as \code{nrow(con)},
the block mixture for the row species. If \code{method = "gnp"}, then
\code{pi} is a probability vector, if \code{method = "gnm"}, then
\code{pi} is the number of species per block, must sum to \code{nr}.}

\item{rho}{A vector of the same length as \code{ncol(con)},
the block mixture for the column species. If \code{method = "gnm"}, then
\code{rho} is a probability vector, if \code{method = "gnm"}, then
\code{rho} is the number of species per block, must sum to \code{nc}.}

\item{nr}{The number of row Species}

\item{nc}{The number of column Species}

\item{method}{One of \code{"gnp"} (the default) where the blocks size and
number of interactions is random and \code{"gnm"} where the blocks size and
number of interactions are fixed.}
}
\value{
A list of 3 elements:
\itemize{
\item \code{A} The incident matrix of size \code{nr}x\code{nc}
\item \code{Z} A vector of length \code{nr}, the block assignment of the row
species
\item \code{W} A vector of length \code{nc}, the block assignment of the column
species
}
}
\description{
Simulate a bipartite interaction network using block model
}
\examples{
# For a random number of interactions and blocks sizes
con <- matrix(c(.5,.3,.3,.1), 2, 2)
pi  <- c(.25,.75)
rho <- c(1/3, 2/3)
nr <- 50
nc <- 30
simulate_lbm(con, pi, rho, nr, nc, method = "gnp")

# For a fixed number of ineractions and blocks sizes
con <- matrix(c(50, 120, 60, 80), 2, 2)
pi  <- c(10, 40)
rho <- c(10, 20)
nr <- 50
nc <- 30
simulate_lbm(con, pi, rho, nr, nc, method = "gnm")
}
