% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ROBIN.R
\name{robinCompareNoParallel}
\alias{robinCompareNoParallel}
\title{robinCompareNoParallel}
\usage{
robinCompareNoParallel(
  graph,
  method1 = c("walktrap", "edgeBetweenness", "fastGreedy", "leadingEigen", "louvain",
    "spinglass", "labelProp", "infomap", "optimal", "leiden", "other"),
  args1 = list(),
  method2 = c("walktrap", "edgeBetweenness", "fastGreedy", "leadingEigen", "louvain",
    "spinglass", "labelProp", "infomap", "optimal", "leiden", "other"),
  args2 = list(),
  FUN1 = NULL,
  FUN2 = NULL,
  measure = c("vi", "nmi", "split.join", "adjusted.rand"),
  type = c("independent", "dependent"),
  verbose = TRUE
)
}
\arguments{
\item{graph}{The output of prepGraph.}

\item{method1}{The first clustering method, one of "walktrap", 
"edgeBetweenness", "fastGreedy", "louvain", "spinglass", "leadingEigen",
"labelProp", "infomap","leiden","optimal","other".}

\item{args1}{A \code{list} of arguments to be passed to the \code{method1} 
(see i.e. \link[igraph]{cluster_leiden} for a list of possible method parameters).}

\item{method2}{The second custering method one of "walktrap",
"edgeBetweenness","fastGreedy", "louvain", "spinglass", "leadingEigen",
"labelProp", "infomap","leiden","optimal","other".}

\item{args2}{A \code{list} of arguments to be passed to the \code{method2}
(see i.e. \link[igraph]{cluster_leiden} for a list of possible method parameters).}

\item{FUN1}{personal designed function when \code{method1} is "other". 
see \code{\link{methodCommunity}}.}

\item{FUN2}{personal designed function when \code{method2} is "other". 
see \code{\link{methodCommunity}}.}

\item{measure}{The stability measure, one of "vi", "nmi", "split.join", 
"adjusted.rand" all normalized and used as distances.
"nmi" refers to 1- nmi and "adjusted.ran" refers to 1-adjusted.rand.}

\item{type}{The type of robin construction, dependent or independent.}

\item{verbose}{flag for verbose output (default as TRUE).}
}
\value{
A list object with two matrices:
- the matrix "Mean1" with the means of the procedure for the first method 
- the matrix "Mean2" with the means of the procedure for the second method
}
\description{
This function compares the robustness of two community 
detection algorithms.
}
\keyword{internal}
