% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/testMediation.R
\name{testMediation}
\alias{indirect}
\alias{print.bootTestMediation}
\alias{print.sobelTestMediation}
\alias{summary.testMediation}
\alias{testMediation}
\alias{testMediation.default}
\alias{testMediation.fitMediation}
\title{(Robust) mediation analysis}
\usage{
testMediation(x, ...)

\method{testMediation}{default}(x, y, m, covariates = NULL, data,
  test = c("boot", "sobel"), alternative = c("twosided", "less", "greater"),
  R = 5000, level = 0.95, type = c("bca", "perc"),
  method = c("covariance", "regression"), robust = TRUE, control, ...)

\method{testMediation}{fitMediation}(x, test = c("boot", "sobel"),
  alternative = c("twosided", "less", "greater"), R = 5000, level = 0.95,
  type = c("bca", "perc"), ...)

indirect(..., test = c("boot", "sobel"), method = "regression",
  robust = FALSE)
}
\arguments{
\item{x}{either a numeric vector containing the independent variable, or
(if \code{data} is supplied) a character string, an integer or a logical
vector specifying the corresponding column of \code{data}.}

\item{y}{either a numeric vector containing the dependent variable, or
(if \code{data} is supplied) a character string, an integer or a logical
vector specifying the corresponding column of \code{data}.}

\item{m}{either a numeric vector containing the proposed mediator variable,
or (if \code{data} is supplied) a character string, an integer or a logical
vector specifying the corresponding column of \code{data}.}

\item{covariates}{optional; either a numeric vector or data frame
containing additional covariates to be used as control variables, or (if
\code{data} is supplied) a character, integer or logical vector specifying
the corresponding column of \code{data}.}

\item{data}{an optional \code{data.frame}.}

\item{test}{a character string specifying the test to be performed for
the indirect effect.  Possible values are \code{"boot"} (the default) for
the bootstrap, or \code{"sobel"} for Sobel's test.}

\item{alternative}{a character string specifying the alternative hypothesis
in the test for the indirect effect.  Possible values are \code{"twosided"}
(the default), \code{"less"} or \code{"greater"}.}

\item{R}{an integer giving the number of bootstrap replicates.  The default
is to use 5000 bootstrap replicates.}

\item{level}{numeric; the confidence level of the confidence interval in
the bootstrap test.  The default is to compute a 95\% confidence interval.}

\item{type}{a character string specifying the type of confidence interval
to be computed in the bootstrap test.  Possible values are \code{"bca"} (the
default) for the bias-corrected and accelerated bootstrap, or \code{"perc"}
for the percentile bootstrap.}

\item{method}{a character string specifying the method of estimation for
the mediation model.  Possible values are \code{"covariance"} (the default)
to estimate the effects via the covariance matrix, or \code{"regression"}
to estimate the effects via regressions.  Note that the effects are always
estimated via regressions if control variables are specified via
\code{covariates}.}

\item{robust}{a logical indicating whether to perform a robust test
(defaults to \code{TRUE}).  This is currently ignored if \code{method} is
\code{"regression"}.}

\item{control}{if \code{robust} is \code{TRUE} and \code{method} is
\code{"covariance"}, a list of tuning parameters for \code{\link{covHuber}}
as generated by \code{\link{covControl}}.}

\item{\dots}{additional arguments to be passed to \code{\link[boot]{boot}}
in case of a bootstrap test.}
}
\value{
An object inheriting from class \code{"testMediation"} (class
\code{"bootTestMediation"} if \code{test} is \code{"boot"} or
\code{"sobelTestMediation"} if \code{test} is \code{"sobel"}) with the
following components:
\item{ab}{numeric; the point estimate of the indirect effect.}
\item{ci}{a numeric vector of length two containing the bootstrap
confidence interval for the indirect effect (only
\code{"bootTestMediation"}).}
\item{reps}{an object of class \code{"\link[boot]{boot}"} containing
the bootstrap replicates of the indirect effect (only
\code{"bootTestMediation"}).}
\item{se}{numeric; the standard error of the indirect effect according
to Sobel's formula (only \code{"sobelTestMediation"}).}
\item{statistic}{numeric; the test statistic for Sobel's test (only
\code{"sobelTestMediation"}).}
\item{pValue}{numeric; the p-Value from Sobel's test (only
\code{"sobelTestMediation"}).}
\item{alternative}{a character string specifying the alternative
hypothesis in the test for the indirect effect.}
\item{R}{an integer giving the number of bootstrap replicates (only
\code{"bootTestMediation"}).}
\item{level}{numeric; the confidence level of the bootstrap confidence
interval (only \code{"bootTestMediation"}).}
\item{type}{a character string specifying the type of bootstrap
confidence interval (only \code{"bootTestMediation"}).}
\item{fit}{an object inheriting from class
\code{"\link{fitMediation}"} containing the estimation results for the
direct effect and the total effect in the mediation model.}
}
\description{
Perform (robust) mediation analysis via a bootstrap test or Sobel's test.
}
\details{
If \code{method} is \code{"covariance"} and \code{robust} is \code{TRUE},
the tests are based on a Huber M-estimator of location and scatter.  For the
bootstrap test, the M-estimates are used to first clean the data via a
transformation.  Then the standard bootstrap is performed with the cleaned
data.  Note that this does not account for the variability from cleaning the
data.

A much more robust method based on robust regression will be available
soon.  Currently, least squares regression is always performed if
\code{method} is \code{"regression"}.

\code{indirect} is a wrapper function for performing non-robust mediation
analysis via regressions (inspired by Preacher & Hayes' \code{SPSS} macro
\code{INDIRECT}).
}
\examples{
# control parameters
n <- 250             # number of observations
a <- b <- c <- 0.2   # true effects
t <- 2               # number of observations to contaminate

# draw clean observations
set.seed(20160911)
x <- rnorm(n)
m <- a * x + rnorm(n)
y <- b * m + c * x + rnorm(n)

# contaminate the first t observations
m[1:t] <- m[1:t] - 6
y[1:t] <- y[1:t] + 6

# perform mediation analysis
test <- testMediation(x, y, m)
summary(test)

}
\author{
Andreas Alfons
}
\references{
Preacher, K.J. and Hayes, A.F. (2004) SPSS and SAS procedures for estimating
indirect effects in simple mediation models. \emph{Behavior Research Methods,
Instruments, & Computers}, \bold{36}(4), 717--731.

Sobel, M.E. (1982) Asymptotic confidence intervals for indirect effects in
structural equation models. \emph{Sociological Methodology}, \bold{13},
290--312.

Zu, J. and Yuan, K.-H. (2010) Local influence and robust procedures for
mediation analysis. \emph{Multivariate Behavioral Research}, \bold{45}(1),
1--44.
}
\seealso{
\code{\link{fitMediation}}

\code{\link[=coef.testMediation]{coef}},
\code{\link[=confint.testMediation]{confint}},
\code{\link[=fortify.testMediation]{fortify}} and
\code{\link[=plotMediation]{plot}} methods

\code{\link[boot]{boot}}, \code{\link{covHuber}}, \code{\link{covML}},
\code{\link[stats]{lm}}
}
\keyword{multivariate}

