% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cov_ML.R
\name{cov_ML}
\alias{cov_ML}
\alias{print.cov_ML}
\title{Maximum likelihood estimator of mean vector and covariance matrix}
\usage{
cov_ML(x, ...)
}
\arguments{
\item{x}{a numeric matrix or data frame.}

\item{\dots}{additional arguments are currently ignored.}
}
\value{
An object of class \code{"cov_ML"} with the following components:
\item{center}{a numeric vector containing the mean vector estimate.}
\item{cov}{a numeric matrix containing the covariance matrix estimate.}
\item{n}{an integer giving the number of observations.}
}
\description{
Compute the maximum likelihood estimator of the mean vector and the
covariance matrix.
}
\examples{
data("BSG2014")

# define variables
x <- "ValueDiversity"
y <- "TeamCommitment"
m <- "TaskConflict"

# compute Huber M-estimator
cov_ML(BSG2014[, c(x, y, m)])

}
\references{
Zu, J. and Yuan, K.-H. (2010) Local influence and robust procedures for
mediation analysis. \emph{Multivariate Behavioral Research}, \bold{45}(1),
1--44.
}
\seealso{
\code{\link{test_mediation}()}, \code{\link{fit_mediation}()}
}
\author{
Andreas Alfons
}
\keyword{multivariate}
