% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_mediation.R
\name{fit_mediation}
\alias{fit_mediation}
\alias{print.fit_mediation}
\alias{summary.reg_fit_mediation}
\alias{summary.cov_fit_mediation}
\title{(Robustly) fit a mediation model}
\usage{
fit_mediation(data, x, y, m, covariates = NULL, method = c("regression",
  "covariance"), robust = TRUE, control, ...)
}
\arguments{
\item{data}{a data frame containing the variables.}

\item{x}{a character string, an integer or a logical vector specifying the
column of \code{data} containing the independent variable.}

\item{y}{a character string, an integer or a logical vector specifying the
column of \code{data} containing the dependent variable.}

\item{m}{a character, integer or logical vector specifying the columns of
\code{data} containing the hypothesized mediator variables.}

\item{covariates}{optional; a character, integer or logical vector
specifying the columns of \code{data} containing additional covariates to be
used as control variables.}

\item{method}{a character string specifying the method of
estimation.  Possible values are \code{"regression"} (the default)
to estimate the effects via regressions, or \code{"covariance"} to
estimate the effects via the covariance matrix.  Note that the effects are
always estimated via regressions if more than one hypothesized mediator is
supplied in \code{m}, or if control variables are specified via
\code{covariates}.}

\item{robust}{a logical indicating whether to robustly estimate the effects
(defaults to \code{TRUE}).}

\item{control}{if \code{robust} is \code{TRUE} and \code{method} is
\code{"regression"}, a list of tuning parameters for
\code{\link[robustbase]{lmrob}} as generated by
\code{\link{reg_control}}.  If \code{robust} is \code{TRUE}
and \code{method} is \code{"covariance"}, a list of tuning parameters for
\code{\link{cov_Huber}} as generated by \code{\link{cov_control}}.}

\item{\dots}{additional arguments can be used to specify tuning parameters
directly instead of via \code{control}.}
}
\value{
An object inheriting from class \code{"fit_mediation"} (class
\code{"reg_fit_mediation"} if \code{method} is \code{"regression"} or
\code{"cov_fit_mediation"} if \code{method} is \code{"covariance"}) with
the following components:
\item{a}{a numeric vector containing the point estimates of the effect of
the independent variable on the proposed mediator variables.}
\item{b}{a numeric vector containing the point estimates of the direct
effect of the proposed mediator variables on the dependent variable.}
\item{c}{numeric; the point estimate of the direct effect of the
independent variable on the dependent variable.}
\item{c_prime}{numeric; the point estimate of the total effect of the
independent variable on the dependent variable.}
\item{fit_mx}{an object of class \code{"\link[robustbase]{lmrob}"} or
\code{"\link[stats]{lm}"} containing the estimation results from the
regression of the proposed mediator variable on the independent variable, or
a list of such objects in case of more than one hypothesized mediator
(only \code{"reg_fit_mediation"}).}
\item{fit_ymx}{an object of class \code{"\link[robustbase]{lmrob}"} or
\code{"\link[stats]{lm}"} containing the estimation results from the
regression of the dependent variable on the proposed mediator and
independent variables (only \code{"reg_fit_mediation"}).}
\item{fit_yx}{an object of class \code{"\link[stats]{lm}"} containing the
estimation results from the regression of the dependent variable on the
independent variable (only \code{"reg_fit_mediation"} and if \code{robust}
is \code{FALSE}).}
\item{cov}{an object of class \code{"\link{cov_Huber}"} or
\code{"\link{cov_ML}"} containing the covariance matrix estimates
(only \code{"cov_fit_mediation"}).}
\item{x, y, m, covariates}{character vectors specifying the respective
variables used.}
\item{data}{a data frame containing the independent, dependent and
proposed mediator variables, as well as covariates.}
\item{robust}{a logical indicating whether the effects were estimated
robustly.}
\item{control}{a list of tuning parameters used (only if \code{robust} is
\code{TRUE}).}
}
\description{
(Robustly) estimate the effects in a mediation model.
}
\details{
If \code{method} is \code{"regression"} and \code{robust} is \code{TRUE}
(the default), the effects are estimated via robust regressions with
\code{\link[robustbase]{lmrob}}.

If \code{method} is \code{"covariance"} and \code{robust} is \code{TRUE},
the effects are estimated based on a Huber M-estimator of location and
scatter.  Note that this covariance-based approach is less robust than the
regression-based one described above.
}
\examples{
data("BSG2014")
fit <- fit_mediation(BSG2014,
                     x = "ValueDiversity",
                     y = "TeamCommitment",
                     m = "TaskConflict")
test <- test_mediation(fit)
summary(test)

}
\references{
Alfons, A., Ates, N.Y. and Groenen, P.J.F. (2018) A robust bootstrap test
for mediation analysis.  \emph{ERIM Report Series in Management}, Erasmus
Research Institute of Management.  URL
\url{https://hdl.handle.net/1765/109594}.

Zu, J. and Yuan, K.-H. (2010) Local influence and robust procedures for
mediation analysis. \emph{Multivariate Behavioral Research}, \bold{45}(1),
1--44.
}
\seealso{
\code{\link{test_mediation}}

\code{\link[robustbase]{lmrob}}, \code{\link[stats]{lm}},
\code{\link{cov_Huber}}, \code{\link{cov_ML}}
}
\author{
Andreas Alfons
}
\keyword{multivariate}
