% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kobo_asset.R
\name{kobo_asset_version_list}
\alias{kobo_asset_version_list}
\title{List all available versions of a KoboToolbox API asset}
\usage{
kobo_asset_version_list(x)
}
\arguments{
\item{x}{the uid or \code{kobo_asset} object.}
}
\value{
A \code{data.frame} containing the list of all the versions
of a given KoboToolbox API asset with the following metadata:
\itemize{
\item \code{uid} the asset version unique identifier.
\item \code{url} the URL of the asset version.
\item \code{deployed} whether or not the asset version is deployed
\item \code{date_modified} when the asset version was last modified
}

a \code{data.frame}
}
\description{
List all available versions of a KoboToolbox API asset and their metadata.
}
\examples{
\dontrun{
kobo_setup() # setup using your url and token
uid <- "a9cwEQcbWqWzA5hzkjRUWi" # pick a valid uid
asset <- kobo_asset(uid)
kobo_asset_version_list(asset)
}

}
