% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forest.robu.R
\name{forest.robu}
\alias{forest.robu}
\title{Forest Plots for Robust Variance Estimation Meta-Analysis}
\usage{
forest.robu(x, es.lab, study.lab, ...)
}
\arguments{
\item{x}{An intercept-only RVE model previously fit using the \code{robu()}
function..}

\item{es.lab}{A vector of labels to be used to individual effect sizes in
the forest plot. Labels for individual effect sizes might be ``Math Score''
or ``Reading Score'' for a meta-analysis that included such measures or as
simple as ``Effect Size 1'' and ``Effect Size 2.''}

\item{study.lab}{A vector of labels to be used to identify study (or
cluster) level groupings in the forest plot. For instance, labels for the
study column might be author names with corresponding publication years.}

\item{...}{Additional arguments to be passed to the forest function. Any
number of additional columns can be specified to be plotted along side the
confidence interval column and can be specified with the following syntax
\code{``arg1'' = ``arg2''} where \code{``arg1''} is the title of the column
on the forest plot, and \code{``arg2''} is the name of the column from the
original \code{data.frame} that contains the information to be displayed
alongside the estimates and confidence intervals.}
}
\description{
\code{forest.robu} In meta-analysis, forest plots provide a graphical
depiction of effect size estimates and their corresponding confidence
intervals. The \code{forest.robu()} function in \pkg{robumeta} can be used
to produce forest plots for RVE meta-analyses. The function requires the
\pkg{grid} package and is based on examples provided in (Murrell, 2011). As
is the case with traditional forest plots, point estimates of individual
effect sizes are plotted as boxes with areas proportional to the weight
assigned to that effect size.  Importantly, here the weight is not
necessarily proportional to the effect size variance or confidence
intervals, since the combined study weight is divided evenly across the
study effect sizes. Two-sided 95\% confidence intervals are calculated for
each effect size using a standard normal distribution and plotted along with
each block. The overall effect is included at the bottom of the plot as a
diamond with width equivalent to the confidence interval for the estimated
effect. The RVE forest function is designed to provide users with forest
plots which display each individual effect size used in the meta-analysis,
while taking into account the study- or cluster-level properties inherent to
the RVE analysis. As such, the user must specify columns from their original
dataset that contain labels for the study or cluster and for the individual
effect sizes.
}
\examples{


# Load data
data(oswald2013.ex1)

# Run intercept only model.
oswald_intercept <- robu(formula = effect.size ~ 1, data = oswald2013.ex1, 
                         studynum = Study, var.eff.size = var.eff.size, 
                         rho = 0.8, small = TRUE)

# Create forest plot. 
forest.robu(oswald_intercept, es.lab = "Crit.Cat", study.lab = "Study", 
            "Effect Size" = effect.size, # optional column
            "Weight" = r.weights)        # optional column

}
\references{
Hedges, L.V., Tipton, E., Johnson, M.C. (2010) Robust variance estimation in
meta-regression with dependent effect size estimates. \emph{Research
Synthesis Methods}. \bold{1}(1): 39--65. Erratum in \bold{1}(2): 164--165.
DOI: 10.1002/jrsm.5

Murrell P (2011). R Graphics. CRC/Taylor & Francis. ISBN 9781439831762.

Tipton, E. (in press) Small sample adjustments for robust variance
estimation with meta-regression. \emph{Psychological Methods}.
}
\keyword{forest.robu}
