##
## loop test for covRob
## Author: Kjell Konis
## Date  : 9/1/2000
##

{
# A. test MCD estimator
  temp <- covRob(stack.dat, estim = "mcd")
	covmat <- c(31.1216916519905,34.37694905467,12.8511123287099,
							25.0225555293878,34.37694905467,39.4923535445949,
							12.2698163639457,28.0452945461616,12.8511123287099,
							12.2698163639457,9.33650749559716,9.39910859949484,
							25.0225555293878,28.0452945461616,9.39910859949484,
							50.5816919493272)
	locvec <- c(13.1538461538462,56.1538461538462,20.2307692307692,
							85.3846153846154)
	all(all.equal(as.vector(temp$cov), covmat),
			all.equal(as.vector(temp$center), locvec))
}


{
# A1. test MCD estimator: correlation matrix
  temp <- covRob(stack.dat, estim = "mcd", corr = T)
	covmat <- c(1,0.980571405623223,0.753905474267168,0.63067176442357,
							0.980571405623223,1,0.638983037772476,0.627490017608493,
							0.753905474267168,0.638983037772476,1,0.432511606499819,
							0.63067176442357,0.627490017608493,0.432511606499819,1)
	locvec <- c(13.1538461538462,56.1538461538462,20.2307692307692,
							85.3846153846154)
	all(all.equal(as.vector(temp$cov), covmat),
			all.equal(as.vector(temp$center), locvec))
}


{
# B. test Donoho-Stahel estimator
  temp <- covRob(stack.dat, estim = "donostah")
	covmat <- c(30.3561426160469,32.1861064716934,12.7273568515657,
							19.5050183523138,32.1861064716934,36.9418923658296,
							12.223170447924,24.1252330617602,12.7273568515657,
							12.223170447924,8.75500771529378,9.72737751016962,
							19.5050183523138,24.1252330617602,9.72737751016962,
							39.2743398047341)
	locvec <- c(13.8328487146801,56.8865212878363,20.5165412032788,
							86.2825992191825)
	all(all.equal(as.vector(temp$cov), covmat),
			all.equal(as.vector(temp$center), locvec))
}


{
# B1. test Donoho-Stahel estimator: correlation matrix
  temp <- covRob(stack.dat, estim = "donostah", corr = T)
	covmat <- c(1,0.961137632564377,0.780704463349654,0.56489616234535,
							0.961137632564377,1,0.679666762063102,0.633370018497198,
							0.780704463349654,0.679666762063102,1,0.524581604968953,
							0.56489616234535,0.633370018497198,0.524581604968953,1)
	locvec <- c(13.8328487146801,56.8865212878363,20.5165412032788,
							86.2825992191825)
	all(all.equal(as.vector(temp$cov), covmat),
			all.equal(as.vector(temp$center), locvec))
}


{
# C. test M estimator
  temp <- covRob(stack.dat, estim = "M")
	covmat <- c(39.5338172063213,41.6379622726864,16.5517675194622,
							29.24362591717,41.6379622726864,49.5019872588692,
							14.4921913645235,35.2608227452194,16.5517675194623,
							14.4921913645235,12.2583803332139,11.2254892460086,
							29.2436259171701,35.2608227452194,11.2254892460086,
							70.3121383248089)
	locvec <- c(13.1443377112745,56.4253674357245,20.0651885796936,
							85.5190443418992)
	all(all.equal(as.vector(temp$cov), covmat),
			all.equal(as.vector(temp$center), locvec))
}


{
# C1. test M estimator: correaltion matrix
  temp <- covRob(stack.dat, estim = "M", corr = T)
	covmat <- c(1,0.941225696500405,0.75187121240007,0.554666187344511,
							0.941225696500405,1,0.588309954841167,0.597676212929781,
							0.751871212400071,0.588309954841168,1,0.382360991694366,
							0.554666187344512,0.597676212929781,0.382360991694366,1)
	locvec <- c(13.1443377112745,56.4253674357245,20.0651885796936,
							85.5190443418992)
	all(all.equal(as.vector(temp$cov), covmat),
			all.equal(as.vector(temp$center), locvec))
}


{
# D. test quadrant-correlation estimator
  temp <- covRob(stack.dat, estim = "pairwiseqc")
	covmat <- c(28.716110520189,20.8532233536958,10.5064784840241,
							9.20864286741146,20.8532233536958,20.9410768415896,
							7.18002596513695,10.3028181257249,10.5064784840241,
							7.18002596513695,6.35340451086367,4.35274099110082,
							9.20864286741146,10.3028181257249,4.35274099110082,
							20.6855030586259)
	locvec <- c(14.3125,57.125,20.3125,86.375)
	all(all.equal(as.vector(temp$cov), covmat),
			all.equal(as.vector(temp$center), locvec))
}


{
# D1. test quadrant-correlation estimator: correlation matrix
  temp <- covRob(stack.dat, estim = "pairwiseqc", corr = T)
	covmat <- c(1,0.850375778589203,0.777841506522661,0.377832906137698,
							0.850375778589203,1,0.622476923770166,0.495020842047739,
							0.777841506522661,0.622476923770166,1,0.379687699883006,
							0.377832906137698,0.495020842047739,0.379687699883006,1)
	locvec <- c(14.3125,57.125,20.3125,86.375)
	all(all.equal(as.vector(temp$cov), covmat),
			all.equal(as.vector(temp$center), locvec))
}


{
# E. test GK estimator
  temp <- covRob(stack.dat, estim = "pairwisegk")
	covmat <- c(15.947804056936,16.3056073530852,7.0666150989468,
							8.62561517502548,16.3056073530852,19.3213779920571,
							5.95486914305463,10.0951644270669,7.0666150989468,
							5.95486914305463,5.42668332492961,4.19566960365437,
							8.62561517502548,10.0951644270669,4.19566960365437,
							20.6588807895672)
	locvec <- c(13.4,56.8,20.0666666666667,86.3333333333333)
	all(all.equal(as.vector(temp$cov), covmat),
			all.equal(as.vector(temp$center), locvec))
}


{
# E1. test GK estimator: correlation matrix
  temp <- covRob(stack.dat, estim = "pairwisegk", corr = T)
	covmat <- c(1,0.928896841428589,0.759615384615385,0.475210729999254,
							0.928896841428589,1,0.581548492752874,0.50529029133178,
							0.759615384615385,0.581548492752874,1,0.396260375914721,
							0.475210729999254,0.50529029133178,0.396260375914721,1)
	locvec <- c(13.4,56.8,20.0666666666667,86.3333333333333)
	all(all.equal(as.vector(temp$cov), covmat),
			all.equal(as.vector(temp$center), locvec))
}


{
# F. clean up
	rm(temp, covmat, locvec)
	T
}
















