% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility.R
\name{varrho}
\alias{varrho}
\title{Calculate varrho coefficients}
\usage{
varrho(sign_level, ref_dist = c("normal"), iteration)
}
\arguments{
\item{sign_level}{A numeric value between 0 and 1 that determines the cutoff
in the reference distribution against which observations are judged as
outliers or not.}

\item{ref_dist}{A character vector that specifies the reference distribution
against which observations are classified as outliers. \code{"normal"} refers
to the normal distribution.}

\item{iteration}{An integer >= 1 that specifies the iteration of the outlier
detection algorithm.}
}
\value{
\code{varrho} returns a list with four components, all of which are
lists themselves. \code{$setting} stores the arguments with which the
function was called. \code{$c} stores the values of the six different
coefficients for the specified iteration. \code{$fp} contains the fixed point
versions of the six coefficients. \code{$aux} stores intermediate values
required for calculating the coefficients.
}
\description{
\code{varrho} calculates the coefficients for the asymptotic variance of the
gauge (false outlier detection rate) for a specific iteration m >= 1.
}
