% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outlier_tests.R
\name{counttest}
\alias{counttest}
\title{Count test}
\usage{
counttest(robust2sls_object, alpha, iteration, one_sided = FALSE)
}
\arguments{
\item{robust2sls_object}{An object of class \code{"robust2sls"} or a
list of such objects.}

\item{alpha}{A numeric value between 0 and 1 representing the significance
level of the test.}

\item{iteration}{An integer >= 0 or the character "convergence" that
determines which iteration is used for the test.}

\item{one_sided}{A logical value whether a two-sided test (\code{FALSE})
should be conducted or a one-sided test (\code{TRUE}) that rejects only
when the number of detected outliers is above the expected number.}
}
\value{
\code{proptest()} returns a data frame with the iteration (m) to be
tested, the actual iteration that was tested (generally coincides with the
iteration that was specified to be tested but is the convergent iteration if
the fixed point is tested), the setting of the probability of exceeding the
cut-off (gamma), the number of detected outliers, the expected number of
outliers under the null hypothesis that there are no outliers, the type of
test (one- or two-sided), the p-value, the significance level \code{alpha},
and the decision. The number of rows of the data frame corresponds to the
length of the argument \code{robust2sls_object}.
}
\description{
\code{counttest()} conducts a test whether the number of detected outliers
deviates significantly from the expected number of outliers under the null
hypothesis that there are no outliers in the sample.
}
\details{
See \code{\link[=outlier_detection]{outlier_detection()}} and
\code{\link[=multi_cutoff]{multi_cutoff()}} for creating an object of class
\code{"robust2sls"} or a list thereof.
}
