% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beta_inf_test.R
\name{beta_t}
\alias{beta_t}
\title{Conducts a t-test on the difference between robust and full sample estimates}
\usage{
beta_t(robust2sls_object, iteration, element, fp = FALSE)
}
\arguments{
\item{robust2sls_object}{An object of class \code{"robust2sls"}.}

\item{iteration}{An integer > 0 specifying the iteration step for which
parameters to calculate corrected standard errors.}

\item{element}{An index or a string to select the coefficient which is to be
tested. The index should refer to the index of coefficients in the
\code{"ivreg"} model object, i.e. \code{$coefficients}.}

\item{fp}{A logical value whether the fixed point asymptotic variance
(TRUE) or the exact iteration asymptotic variance should be used (FALSE).}
}
\value{
\code{beta_t} returns a matrix with the robust and full sample
estimates of beta, the t statistic on their difference, the standard error of
the difference, and three p-values (two-sided, both one-sided alternatives).
}
\description{
Conducts a t-test on the difference between robust and full sample estimates
}
\details{
Argument \code{fp} determines whether the fixed point asymptotic variance
should be used. This argument is only respected if the specified
\code{iteration} is one of the iterations after the algorithm converged.
}
