% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emp_FSBT.R
\name{kdeFSBT}
\alias{kdeFSBT}
\title{Full Significance Bayesian Testing}
\usage{
kdeFSBT(H0, sim.sample)
}
\arguments{
\item{H0}{a scalar value under the null hypothesis.}

\item{sim.sample}{a sample from the marginal posterior distribution.}
}
\value{
double
}
\description{
Performs Full Significance Bayesian Testing (FSBT) for univariate sharp
null hypothesis based on a posterior sample. The marginal posterior density is obtained by kernel density estimation from \code{sim.sample}.
}
\examples{

x <-  rnorm(1000, 0, 1)
kdeFSBT(-1, x)

}
\references{
Pereira, C. A. d. B., Stern, J. M. and Wechsler, S. (2008) Can a significance test be genuinely Bayesian? \emph{Bayesian Analysis} \bold{3}, 79-100.
}
