% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manageDatasets.R
\name{splitDatasets}
\alias{splitDatasets}
\title{Split Datasets Into Chunks}
\usage{
splitDatasets(datasets, chunkSize = 50)
}
\arguments{
\item{datasets}{dataset object to split into chunks}

\item{chunkSize}{number of datasets to keep in one chunk}
}
\value{
list of dataset lists with generators and the contents of the
  original dataset. See `\code{\link{prepareMixedEffectDataset}} and
  \code{\link{generateAnovaDatasets}} for a description of the contents.
  There is one additional entry in the list: \itemize{
  \item{\code{"chunkIndex"}: }{index of the chunk} }
}
\description{
Method that splits up dataset objects into smaller chunks, so that they can
be processed separately.
}
\examples{
  oneWay <- generateAnovaDatasets(18, 1, 5, 4)
  datasetList <- splitDatasets(oneWay, 5)
  data <- datasetList[[4]]$generateData(1)
  stopifnot(all.equal(oneWay$generateData(16), datasetList[[4]]$generateData(1),
                      check.attributes = TRUE),
            all.equal(oneWay$sphericalRandomEffects(16),
                      datasetList[[4]]$sphericalRandomEffects(1)),
            all.equal(oneWay$createXMatrix(data), datasetList[[4]]$createXMatrix(data)),
            all.equal(oneWay$createZMatrix(data), datasetList[[4]]$createZMatrix(data)))
}
\seealso{
\code{\link{bindDatasets}}
}
\author{
Manuel Koller
}
