% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/processFile.R
\name{processFile}
\alias{processFile}
\title{Process File of Stored Datasets}
\usage{
processFile(
  file,
  fittingFunctions,
  saveFitted = FALSE,
  checkProcessed = FALSE,
  createMinimalSaveFile = FALSE,
  datasets,
  ...
)
}
\arguments{
\item{file}{file saved by \code{\link{saveDatasets}}.}

\item{fittingFunctions}{vector of \code{\link{fitDatasets}} functions that
should be applied to each dataset.}

\item{saveFitted}{logical, if true, the raw fits are also stored.}

\item{checkProcessed}{logical, if true, will check whether the contents of
the processed output is reproduced for the first dataset. This is useful
to ensure that everything is still working as expected without having to
re-run the whole simulation study.}

\item{createMinimalSaveFile}{logical, if true, will create a file with the
processed results of the first three datasets. This is helpful if one
wants to store only the final aggregated results but still wants to make
sure that the full code works as expected.}

\item{datasets}{optional, datasets as stored in \code{file}, to avoid doing
a detour of saving and loading the file.}

\item{...}{passed on to \code{\link{processFit}}. Use this to control what
to save.}
}
\value{
The list of all processed results merged together.

  To help reproduciblility, the output of \code{toLatex(sessionInfo(),
  locale = FALSE)} is stored in the \code{sessionInfo} attribute.
}
\description{
Call this function for each file stored using \code{\link{saveDatasets}}. If
a file hasn't been processed yet, then it is processed and a new file with
the postfix \dQuote{processed} is created containing the results.
}
\details{
In case the raw fits may have to be inspected or \code{\link{processFit}}
may be called with another set of arguments, then set \code{saveFitted} to
TRUE. In that case, another file with the postfix \dQuote{fitted} is
created. Remove the files with postfix \dQuote{processed} and run
\code{processFile} again. The fits will not be re-done but instead loaded
from the file with postfix \dQuote{fitted}.
}
\author{
Manuel Koller
}
