% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collect_coded_fragments.R
\name{collect_coded_fragments}
\alias{collect_coded_fragments}
\title{Create an overview of coded fragments}
\usage{
collect_coded_fragments(x, codes = ".*", context = 0, heading = NULL,
  headingLevel = 2, add_html_tags = TRUE, cleanUtterances = FALSE,
  output = NULL, template = "default", rawResult = FALSE,
  preventOverwriting = rock::opts$get(preventOverwriting),
  silent = rock::opts$get(silent))
}
\arguments{
\item{x}{The parsed source(s) as provided by \code{rock::parse_source}
or \code{rock::parse_sources}.}

\item{codes}{The regular expression that matches the codes to include}

\item{context}{How many utterances before and after the target
utterances to include in the fragments.}

\item{heading}{Optionally, a title to include in the output. The title
will be prefixed with \code{headingLevel} hashes (\code{#}), and the codes with
\code{headingLevel+1} hashes. If \code{NULL} (the default), a heading will be
generated that includes the collected codes if those are five or less.
If a character value is specified, that will be used. To omit a heading,
set to anything that is not \code{NULL} or a character vector (e.g. \code{FALSE}).
If no heading is used, the code prefix will be \code{headingLevel} hashes,
instead of \code{headingLevel+1} hashes.}

\item{headingLevel}{The number of hashes to insert before the headings.}

\item{add_html_tags}{Whether to add HTML tags to the result.}

\item{cleanUtterances}{Whether to use the clean or the raw utterances
when constructing the fragments (the raw versions contain all codes). Note that
this should be set to \code{FALSE} to have \code{add_html_tags} be of the most use.}

\item{output}{Here, a path and filename can be provided where the
result will be written. If provided, the result will be returned
invisibly.}

\item{template}{The template to load; either the name of one
of the ROCK templates (currently, only 'default' is available), or
the path and filename of a CSS file.}

\item{rawResult}{Whether to return the raw result, a list of the
fragments, or one character value in markdown format.}

\item{preventOverwriting}{Whether to prevent overwriting of output files.}

\item{silent}{Whether to provide (\code{FALSE}) or suppress (\code{TRUE}) more detailed progress updates.}
}
\value{
Either a list of character vectors, or a single character value.
}
\description{
Collect all coded utterances and optionally add some context
(utterances before and utterances after) to create ann overview
of all coded fragments per code.
}
\details{
By default, the output is optimized for inclusion in an R Markdown
document. To optimize output for the R console or a plain text
file, without any HTML codes, set \code{add_html_tags} to FALSE, and
potentially set \code{cleanUtterances} to only return the utterances,
without the codes.
}
\examples{
### Get path to example source
examplePath <-
  system.file("extdata", package="rock");

### Get a path to one example file
exampleFile <-
  file.path(examplePath, "example-1.rock");

### Parse single example source
parsedExample <- rock::parse_source(exampleFile);

### Show organised coded fragments in Markdown
cat(collect_coded_fragments(parsedExample));

### Only for the codes containing 'Code2'
cat(collect_coded_fragments(parsedExample,
                            'Code2'));

}
