\name{predictCI}
\alias{predictCI}
\title{Calculate a predicted value matrix (fit, lwr, upr) for a
regression, either lm or glm, on either link or response scale.}
\usage{
  predictCI(object, newdata = NULL,
    type = c("response", "link"),
    interval = c("none", "confidence", "prediction"),
    dispersion = NULL, scale = NULL, na.action = na.pass,
    level = 0.95, ...)
}
\arguments{
  \item{object}{Regression object, class must include glm
  or lm.}

  \item{newdata}{Data frame including focal values for
  predictors}

  \item{type}{One of c("response", "link"), defaults to
  former.}

  \item{interval}{One of c("none", "confidence",
  "prediction"). "prediction" is defined only for lm
  objects, not for glm.}

  \item{dispersion}{Will be estimated if not provided. The
  variance coefficient of the glm, same as scale squared.
  Dispersion is allowed as an argument in predict.glm.}

  \item{scale}{The square root of dispersion. In an lm,
  this is the RMSE, called sigma in summary.lm.}

  \item{na.action}{What to do with missing values}

  \item{level}{0.95 or whatever confidence level one
  desires.}

  \item{...}{Other arguments to be passed to predict}
}
\value{
  c(fit, lwr, upr), and possibly more.
}
\description{
  This adapts code from predict.glm and predict.lm. I
  eliminated type = "terms" from consideration.
}
\details{
  R's predict.glm does not have an interval argument. There
  are about 50 methods to calculate CIs for predicted
  values of GLMs, that's a major worry. I don't want to
  simulate them, that seems brutish.  This function takes
  the simplest route, calculating the (fit, lwr, upr) in
  the linear predictor scale, and then if type= "response",
  those 3 columns are put through linkinv().  This is the
  same method that SAS manuals suggest they use, same as
  Ben Bolker suggests in r-help (2010).  I'd rather use one
  of the fancy tools like Edgeworth expansion, but that R
  code is not available (but is promised).

  Use predict.lm with se.fit = TRUE to calculate fit and
  se.fit. Then calculate lwr and upr as fit +/- tval *
  se.fit. If model is lm, the model df.residual will be
  used to get tval. If glm, this is a normal approximation,
  so we thugishly assert tval = 1.98.

  There's some confusing term translation. I wish R lm and
  glm would be brought into line. For lm, residual.scale =
  sigma. For glm, residual.scale = sqrt(dispersion)
}

