% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flat_table.R, R/generic.R, R/star_database.R
\name{get_similar_attribute_values.flat_table}
\alias{get_similar_attribute_values.flat_table}
\alias{get_similar_attribute_values}
\alias{get_similar_attribute_values.star_database}
\title{Get similar attribute values combination}
\usage{
\method{get_similar_attribute_values}{flat_table}(
  db,
  name = NULL,
  attributes = NULL,
  exclude_numbers = FALSE,
  col_as_vector = NULL
)

get_similar_attribute_values(
  db,
  name,
  attributes,
  exclude_numbers,
  col_as_vector
)

\method{get_similar_attribute_values}{star_database}(
  db,
  name = NULL,
  attributes = NULL,
  exclude_numbers = FALSE,
  col_as_vector = NULL
)
}
\arguments{
\item{db}{A \code{flat_table} or \code{star_database} object.}

\item{name}{A string, dimension name.}

\item{attributes}{A vector of strings, attribute names.}

\item{exclude_numbers}{A boolean, exclude numbers from comparison.}

\item{col_as_vector}{A string, name of the column to include a vector of values.}
}
\value{
A vector of \code{tibble} objects with similar instances.
}
\description{
Get sets of attribute values that differ only by tildes, spaces, or punctuation
marks, for the combination of the given set of attributes. If no attributes are
indicated, they are all considered together.
}
\details{
For star databases, a list of dimensions can be indicated, otherwise it
considers all dimensions. If a dimension is indicated, a list of attributes
to be considered in it can also be indicated.

You can indicate that the numbers are ignored to make the comparison.

If a name is indicated in the \code{col_as_vector} parameter, it includes a column
with the data in vector form to be used in other functions.
}
\examples{

instances <- star_database(mrs_cause_schema, ft_num) |>
  get_similar_attribute_values(name = "where")

db <- star_database(mrs_cause_schema, ft_num)
db$dimensions$where$table$City[2] <- " BrId  gEport "
instances <- db |>
  get_similar_attribute_values("where")

db <- star_database(mrs_cause_schema, ft_num)
db$dimensions$where$table$City[2] <- " BrId  gEport "
instances <- db |>
  get_similar_attribute_values("where",
    attributes = c("City", "State"),
    col_as_vector = "As a vector")

ft <- flat_table('iris', iris)
ft$table$Species[20] <- "se.Tosa."
ft$table$Species[60] <- "Versicolor"
instances <- ft |>
  get_similar_attribute_values()

}
\seealso{
\code{\link{star_database}}, \code{\link{flat_table}}

Other star database and flat table functions: 
\code{\link{get_attribute_names.flat_table}()},
\code{\link{get_measure_names.flat_table}()},
\code{\link{get_similar_attribute_values_individually.flat_table}()},
\code{\link{get_unique_attribute_values.flat_table}()},
\code{\link{replace_attribute_values.flat_table}()},
\code{\link{set_attribute_names.flat_table}()},
\code{\link{set_measure_names.flat_table}()},
\code{\link{snake_case.flat_table}()}
}
\concept{star database and flat table functions}
