% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/star_database_export.R
\name{as_csv_files}
\alias{as_csv_files}
\alias{as_csv_files.star_database}
\title{Generate csv files with fact and dimension tables}
\usage{
as_csv_files(db, dir, type)

\method{as_csv_files}{star_database}(db, dir = NULL, type = 1)
}
\arguments{
\item{db}{A \code{star_database} object.}

\item{dir}{A string, name of a dir.}

\item{type}{An integer, 1: uses "." for the decimal point and a comma for the
separator; 2: uses a comma for the decimal point and a semicolon for the
separator.}
}
\value{
A string, name of a dir.
}
\description{
To port databases to other work environments it is useful to be able to
export them as csv files, as this function does.
}
\examples{

db1 <- star_database(mrs_cause_schema, ft_num) |>
  snake_case()
tl1 <- db1 |>
  as_csv_files()

db2 <- star_database(mrs_age_schema, ft_age) |>
  snake_case()

ct <- constellation("MRS", db1, db2)
d <- ct |>
  as_csv_files(dir = tempdir())

}
\seealso{
\code{\link{star_database}}

Other star database exportation functions: 
\code{\link{as_dm_class}()},
\code{\link{as_multistar}()},
\code{\link{as_rdb}()},
\code{\link{as_single_tibble_list}()},
\code{\link{as_tibble_list}()},
\code{\link{as_xlsx_file}()},
\code{\link{draw_tables}()}
}
\concept{star database exportation functions}
