% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/star_database_export.R
\name{as_rdb}
\alias{as_rdb}
\alias{as_rdb.star_database}
\title{Generate tables in a relational database}
\usage{
as_rdb(db, con, overwrite)

\method{as_rdb}{star_database}(db, con, overwrite = FALSE)
}
\arguments{
\item{db}{A \code{star_database} object.}

\item{con}{A \code{DBI::DBIConnection} object.}

\item{overwrite}{A boolean, allow overwriting tables in the database.}
}
\value{
Invisible NULL.
}
\description{
Given a connection to a relational database, it stores the facts and
dimensions in the form of tables. Tables can be overwritten.
}
\examples{

my_db <- DBI::dbConnect(RSQLite::SQLite())

db <- star_database(mrs_cause_schema, ft_num) |>
  snake_case()
db |>
  as_rdb(my_db)

DBI::dbDisconnect(my_db)

}
\seealso{
\code{\link{star_database}}

Other star database exportation functions: 
\code{\link{as_csv_files}()},
\code{\link{as_dm_class}()},
\code{\link{as_multistar}()},
\code{\link{as_single_tibble_list}()},
\code{\link{as_tibble_list}()},
\code{\link{as_xlsx_file}()},
\code{\link{draw_tables}()}
}
\concept{star database exportation functions}
