% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export.R
\name{export_tomic_as_wide}
\alias{export_tomic_as_wide}
\title{Export T*Omic as Wide Data}
\usage{
export_tomic_as_wide(
  tomic,
  dir_path,
  name_preamble,
  value_var = NULL,
  transpose = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{tomic}{Either a \code{tidy_omic} or \code{triple_omic} object}

\item{dir_path}{path to save outputs}

\item{name_preamble}{start of output file name}

\item{value_var}{measurement variable to use for the matrix}

\item{transpose}{if TRUE then samples will be stored as rows}

\item{verbose}{extra reporting messages}
}
\value{
Export one table which contains metabolites as rows and samples
  as columns.
}
\description{
abundances form a matrix with metabolites as rows and samples as columns.
  Use transpose to treat samples as rows
filename
}
\examples{

if (interactive()) {
  export_tomic_as_wide(brauer_2008_triple, "/tmp", "brauer")
}
}
