% Generated by roxygen2 (4.0.1): do not edit by hand
\name{addAssignmentsUB}
\alias{addAssignmentsUB}
\title{Add upper bound of alternative possible assignments}
\usage{
addAssignmentsUB(problem, ...)
}
\arguments{
\item{problem}{Problem to which preference information will be added.}

\item{...}{Assignments as two-element vectors.
Each vector \code{c(i, j)} represents assignment of an alternative \emph{a_i}
to at most class as good as \emph{C_j}.}
}
\value{
Problem with added assignment examples.
}
\description{
This function adds upper bounds of possible assignments to a problem.
}
\examples{
# 4 alternatives, 2 gain criteria, 3 classes, monotonously increasing
# and general marginal value functions
perf <- matrix(c(5, 2, 1, 7, 0.5, 0.9, 0.4, 0.4), ncol = 2)
problem <- buildProblem(perf, 3, FALSE, c('g', 'g'), c(0, 0))

# add assignment examples: alternative 3 at most to class as good as class 1
# and alternative 4 to class at most as good as class 2
problem <- addAssignmentsUB(problem, c(3, 1), c(4, 2))
}
\seealso{
\code{\link{buildProblem}}
\code{\link{removeAssignmentsUB}}
}

