% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/object-s3.R
\name{is_s3_generic}
\alias{is_s3_generic}
\alias{is_s3_method}
\title{Determine if a function is an S3 generic or S3 method.}
\usage{
is_s3_generic(name, env = parent.frame())

is_s3_method(name, env = parent.frame())
}
\arguments{
\item{name}{Name of function.}

\item{env}{Base environment in which to look for function defintion.}
}
\description{
\code{is_s3_generic} compares name to \code{.knownS3Generics} and
\code{.S3PrimitiveGenerics}, then looks at the function body to see if it
calls \code{\link[=UseMethod]{UseMethod()}}.

\code{is_s3_method} builds names of all possible generics for that function
and then checks if any of them actually is a generic.
}
