# code blocks work

    Before
    
    \if{html}{\out{<div class="sourceCode">}}\preformatted{x \%in\% 1:10
    }\if{html}{\out{</div>}}
    
    After

# code block with language creates HTML tag

    Before
    
    \if{html}{\out{<div class="sourceCode r">}}\preformatted{x \%in\% 1:10
    }\if{html}{\out{</div>}}
    
    After

# can convert table to Rd

    Code
      for (table in tables) {
        cat_line(table)
        cat_line(markdown(table))
        cat_line()
      }
    Output
      
      | x   | y   |
      | --- | --- |
      | 1   | 2   |
      \tabular{ll}{
         x \tab y \cr
         1 \tab 2 \cr
      }
      
      | x   | y   |
      | :-: | --: |
      | 1   | 2   |
      \tabular{cr}{
         x \tab y \cr
         1 \tab 2 \cr
      }
      
      | x     | y         |
      | ----- | --------- |
      | 1 _2_ | 3 *4* `5` |
        
      \tabular{ll}{
         x \tab y \cr
         1 \emph{2} \tab 3 \emph{4} \code{5} \cr
      }
      

# unhandled markdown generates warning

    [<text>:4] @description markdown translation failed
    x block quotes are not currently supported

# level 1 heading in markdown generates warning in some tags

    [<text>:4] @seealso markdown translation failed
    x Level 1 headings are not supported in @seealso
    i Do you want to put the heading in @description or @details?

# alternative knitr engines

    Code
      print(out1 <- roc_proc_text(rd_roclet(),
      "\n      #' Title\n      #'\n      #' Description.\n      #'\n      #' ```{verbatim}\n      #' #| file = testthat::test_path(\"example.Rmd\")\n      #' ```\n      #' @md\n      #' @name x\n      NULL\n    "))
    Output
      $x.Rd
      % Generated by roxygen2: do not edit by hand
      % Please edit documentation in ./<text>
      \name{x}
      \alias{x}
      \title{Title}
      \description{
      Description.
      }
      \details{
      \if{html}{\out{<div class="sourceCode default">}}\preformatted{```\{r\}
      # comment
      this <- 10
      is <- this + 10
      good <- this + is
      }\if{html}{\out{</div>}}
      }
      

# image formats work

    Code
      roc_proc_text(rd_roclet(),
      "\n      #' Title\n      #'\n      #' ![](example.svg \"Plot title 1\")\n      #' ![](example.pdf \"Plot title 2\")\n      #' ![](example.PNG \"Plot title 3\")\n      #' @md\n      foo <- function() { }\n    ")[[
        1]]
    Output
      % Generated by roxygen2: do not edit by hand
      % Please edit documentation in ./<text>
      \name{foo}
      \alias{foo}
      \title{Title}
      \usage{
      foo()
      }
      \description{
      \if{html}{\figure{example.svg}{Plot title 1}}
      \if{pdf}{\figure{example.pdf}{Plot title 2}}
      \figure{example.PNG}{Plot title 3}
      }

