% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collate.R
\name{update_collate}
\alias{update_collate}
\alias{@include}
\title{Update Collate field in DESCRIPTION}
\usage{
update_collate(base_path)
}
\arguments{
\item{base_path}{Path to package directory.}
}
\description{
By default, R loads files in alphabetical order. Unfortunately not every
alphabet puts letters in the same order, so you can't rely on alphabetic
ordering if you need one file loaded before another. (This usually doesn't
matter but is important for S4, where you need to make sure that classes are
loaded before subclasses and generics are defined before methods.).
You can override the default alphabetical ordering with \verb{@include before.R},
which specify that \code{before.R} must be loaded before the current file.

Generally, you will not need to run this function yourself; it should be
run automatically by any package that needs to load your R files in
collation order.
}
\section{Collate}{

This is not a roclet because roclets need the values of objects in a package,
and those values can not be generated unless you've sourced the files,
and you can't source the files unless you know the correct order.

If there are no \verb{@include} tags, roxygen2 will leave collate as is.
This makes it easier to use roxygen2 with an existing collate directive,
but if you remove all your \verb{@include} tags, you'll need to also
manually delete the collate field.
}

\examples{
#' If `example-a.R', `example-b.R' and `example-c.R' live in R/
#' and we're in `example-a.R`, then the following @include statement
#' ensures that example-b and example-c are sourced before example-a.
#' @include example-b.R example-c.R
NULL
}
